/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.util.ToolRunner;

public class SequentialPageRank {
    private static final String INPUT = "input";
    private static final String JUMP = "jump";

    private SequentialPageRank() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"val");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"random jump factor");
        options.addOption(OptionBuilder.create((String)JUMP));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(SequentialPageRank.class.getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String infile = cmdline.getOptionValue(INPUT);
        float alpha = cmdline.hasOption(JUMP) ? Float.parseFloat(cmdline.getOptionValue(JUMP)) : 0.15f;
        int edgeCnt = 0;
        DirectedSparseGraph graph = new DirectedSparseGraph();
        BufferedReader data = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
        while ((line = data.readLine()) != null) {
            line.trim();
            String[] arr = line.split("\\t");
            for (int i = 1; i < arr.length; ++i) {
                graph.addEdge((Object)new Integer(edgeCnt++), (Object)arr[0], (Object)arr[i]);
            }
        }
        data.close();
        WeakComponentClusterer clusterer = new WeakComponentClusterer();
        Set components = clusterer.transform((Graph)graph);
        int numComponents = components.size();
        System.out.println("Number of components: " + numComponents);
        System.out.println("Number of edges: " + graph.getEdgeCount());
        System.out.println("Number of nodes: " + graph.getVertexCount());
        System.out.println("Random jump factor: " + alpha);
        PageRank ranker = new PageRank((Hypergraph)graph, (double)alpha);
        ranker.evaluate();
        PriorityQueue<Ranking> q = new PriorityQueue<Ranking>();
        int i = 0;
        for (String pmid : graph.getVertices()) {
            q.add(new Ranking(i++, ((Double)ranker.getVertexScore((Object)pmid)).doubleValue(), (Object)pmid));
        }
        System.out.println("\nPageRank of nodes, in descending order:");
        Ranking r = null;
        while ((r = (Ranking)q.poll()) != null) {
            System.out.println(r.rankScore + "\t" + (String)r.getRanked());
        }
    }
}

