/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.simple;

import edu.umd.cloud9.mapred.NullInputFormat;
import edu.umd.cloud9.mapred.NullMapper;
import java.io.IOException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.log4j.Logger;

public class DemoMapredNullInput {
    private static final Logger LOG = Logger.getLogger(DemoMapredNullInput.class);

    private DemoMapredNullInput() {
    }

    public static void main(String[] args) throws IOException {
        JobConf conf = new JobConf(DemoMapredNullInput.class);
        conf.setJobName("DemoMapredNullInput");
        conf.setNumMapTasks(10);
        conf.setNumReduceTasks(0);
        conf.setInputFormat(NullInputFormat.class);
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setMapperClass(MyMapper.class);
        JobClient.runJob((JobConf)conf);
    }

    private static class MyMapper
    extends NullMapper {
        private MyMapper() {
        }

        @Override
        public void run(JobConf conf, Reporter reporter) throws IOException {
            LOG.info((Object)"Counting to 10:");
            for (int i = 0; i < 10; ++i) {
                LOG.info((Object)(i + 1 + "..."));
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

