/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.simple;

import edu.umd.cloud9.io.JsonWritable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class DemoPackJson {
    private static final Logger LOG = Logger.getLogger(DemoPackJson.class);

    private DemoPackJson() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length != 2) {
            System.out.println("usage: [input] [output]");
            System.exit(-1);
        }
        String infile = args[0];
        String outfile = args[1];
        LOG.info((Object)("input: " + infile));
        LOG.info((Object)("output: " + outfile));
        Configuration conf = new Configuration();
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(outfile)), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(JsonWritable.class)});
        BufferedReader data = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
        LongWritable key = new LongWritable();
        JsonWritable json = new JsonWritable();
        long cnt = 0L;
        while ((line = data.readLine()) != null) {
            json.getJsonObject().addProperty("text", line);
            key.set(cnt);
            writer.append((Writable)key, (Writable)json);
            ++cnt;
        }
        data.close();
        writer.close();
        LOG.info((Object)("Wrote " + cnt + " records."));
    }
}

