/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.simple;

import edu.umd.cloud9.io.pair.PairOfStringInt;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.apache.pig.data.Tuple;

public class DemoWordCountTuple1
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(DemoWordCountTuple1.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 3) {
            DemoWordCountTuple1.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int numReduceTasks = Integer.parseInt(args[2]);
        LOG.info((Object)("Tool: " + DemoWordCountTuple1.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - number of reducers: " + numReduceTasks));
        Configuration conf = this.getConf();
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(DemoWordCountTuple1.class.getSimpleName());
        job.setJarByClass(DemoWordCountTuple1.class);
        job.setNumReduceTasks(numReduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(PairOfStringInt.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setCombinerClass(MyReducer.class);
        job.setReducerClass(MyReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        LOG.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DemoWordCountTuple1(), (String[])args);
    }

    private static class MyReducer
    extends Reducer<PairOfStringInt, IntWritable, PairOfStringInt, IntWritable> {
        private static final IntWritable SUM = new IntWritable();

        private MyReducer() {
        }

        public void reduce(PairOfStringInt tupleKey, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<IntWritable> iter = values.iterator();
            int sum = 0;
            while (iter.hasNext()) {
                sum += iter.next().get();
            }
            SUM.set(sum);
            context.write((Object)tupleKey, (Object)SUM);
        }
    }

    private static class MyMapper
    extends Mapper<LongWritable, Tuple, PairOfStringInt, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private static final PairOfStringInt PAIR = new PairOfStringInt();

        private MyMapper() {
        }

        public void map(LongWritable key, Tuple tuple, Mapper.Context context) throws IOException, InterruptedException {
            String line = (String)tuple.get(0);
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                String token = itr.nextToken();
                PAIR.set(token, line.length() % 2);
                context.write((Object)PAIR, (Object)one);
            }
        }
    }
}

