/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;

public class IntegrationUtils {
    public static final String LOCAL_ARGS = "-D fs.defaultFS=file:/// -D mapreduce.framework.name=local -D mapreduce.jobtracker.address=local -D mapreduce.cluster.local.dir=/tmp/mapred/local -D mapreduce.cluster.temp.dir=/tmp/mapred/temp -D mapreduce.jobtracker.staging.root.dir=/tmp/mapred/staging -D mapreduce.jobtracker.system.dir=/tmp/mapred/system";
    public static final String D_JT = "-Dmapred.job.tracker=bespin00.umiacs.umd.edu:8021";
    public static final String D_NN = "-Dfs.defaultFS=hdfs://bespinrm.umiacs.umd.edu:8020";
    public static final String D_JT_LOCAL = "-D mapred.job.tracker=local";
    public static final String D_NN_LOCAL = "-D fs.default.name=file:///";

    public static String getJar(String path, final String prefix) {
        File[] arr = new File(path).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && !name.contains("javadoc") && !name.contains("sources");
            }
        });
        Assert.assertTrue((arr.length == 1 ? 1 : 0) != 0);
        return arr[0].getAbsolutePath();
    }

    public static Configuration getBespinConfiguration() {
        Configuration conf = new Configuration();
        conf.addResource(new Path("/etc/hadoop/conf/core-site.xml"));
        conf.addResource(new Path("/etc/hadoop/conf/hdfs-site.xml"));
        conf.addResource(new Path("/etc/hadoop/conf/mapred-site.xml"));
        conf.addResource(new Path("/etc/hadoop/conf/yarn-site.xml"));
        conf.reloadConfiguration();
        return conf;
    }

    public static int exec(String cmd) throws IOException, InterruptedException {
        System.out.println("Executing command: " + cmd);
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "STDERR");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "STDOUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("ExitValue: " + exitVal);
        return exitVal;
    }

    public static List<Integer> execWiki(String cmd) throws IOException, InterruptedException {
        System.out.println("Executing command: " + cmd);
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        WikiGobbler errorGobbler = new WikiGobbler(proc.getErrorStream(), "STDERR");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "STDOUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("ExitValue: " + exitVal);
        return ImmutableList.of((Object)errorGobbler.disambCount, (Object)errorGobbler.articleCount, (Object)errorGobbler.totalCount);
    }

    public static Map<String, Integer> execKeyValueExtractor(String cmd, Set<String> keys) throws IOException, InterruptedException {
        System.out.println("Executing command: " + cmd);
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        KeyValuePairsGobbler errorGobbler = new KeyValuePairsGobbler(proc.getErrorStream(), "STDERR", keys);
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "STDOUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("ExitValue: " + exitVal);
        return errorGobbler.map;
    }

    private static class KeyValuePairsGobbler
    extends StreamGobbler {
        Map<String, Integer> map = Maps.newHashMap();
        private Set<String> keys;

        KeyValuePairsGobbler(InputStream is, String type, Set<String> keys) {
            super(is, type);
            this.keys = keys;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                    for (String key : this.keys) {
                        if (!line.contains(key + "=")) continue;
                        String[] arr = line.trim().split(key + "=");
                        this.map.put(key, Integer.parseInt(arr[1]));
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class WikiGobbler
    extends StreamGobbler {
        int disambCount = 0;
        int articleCount = 0;
        int totalCount = 0;

        WikiGobbler(InputStream is, String type) {
            super(is, type);
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] arr;
                    System.out.println(this.type + ">" + line);
                    if (line.contains("DISAMBIGUATION=")) {
                        arr = line.trim().split("DISAMBIGUATION=");
                        this.disambCount = Integer.parseInt(arr[1]);
                        continue;
                    }
                    if (line.contains("ARTICLE=") && !line.contains("NON_ARTICLE=")) {
                        arr = line.trim().split("ARTICLE=");
                        this.articleCount = Integer.parseInt(arr[1]);
                        continue;
                    }
                    if (!line.contains("TOTAL=")) continue;
                    arr = line.trim().split("TOTAL=");
                    this.totalCount = Integer.parseInt(arr[1]);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

