/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.collection.medline;

import com.google.common.base.Joiner;
import edu.umd.cloud9.collection.medline.CountMedlineCitations;
import edu.umd.cloud9.collection.medline.MedlineDocnoMapping;
import edu.umd.cloud9.collection.medline.MedlineDocnoMappingBuilder;
import edu.umd.cloud9.integration.IntegrationUtils;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;

public class IntegrationTest {
    private static final Random random = new Random();
    private static final Path collectionPath = new Path("/shared/collections/medline04");
    private static final String tmpPrefix = "tmp-" + IntegrationTest.class.getCanonicalName() + "-" + random.nextInt(10000);
    private static final String mappingFile = tmpPrefix + "-mapping.dat";

    @org.junit.Test
    public void testDocnoMapping() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), MedlineDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + collectionPath, "-docnoMapping=" + mappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        MedlineDocnoMapping mapping = new MedlineDocnoMapping();
        mapping.loadMapping(new Path(mappingFile), fs);
        Assert.assertEquals((Object)"45641", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"45740", (Object)mapping.getDocid(100));
        Assert.assertEquals((Object)"7472623", (Object)mapping.getDocid(10000));
        Assert.assertEquals((Object)"8739651", (Object)mapping.getDocid(1000000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("45641"));
        Assert.assertEquals((long)100L, (long)mapping.getDocno("45740"));
        Assert.assertEquals((long)10000L, (long)mapping.getDocno("7472623"));
        Assert.assertEquals((long)1000000L, (long)mapping.getDocno("8739651"));
    }

    @org.junit.Test
    public void testDemoCountDocs() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        String output = tmpPrefix + "-cnt";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), CountMedlineCitations.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + collectionPath, "-output=" + output, "-docnoMapping=" + mappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(IntegrationTest.class);
    }
}

