/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.collection.trec;

import com.google.common.base.Joiner;
import edu.umd.cloud9.collection.trec.CountTrecDocuments;
import edu.umd.cloud9.collection.trec.TrecDocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocnoMappingBuilder;
import edu.umd.cloud9.collection.trec.TrecForwardIndex;
import edu.umd.cloud9.collection.trec.TrecForwardIndexBuilder;
import edu.umd.cloud9.integration.IntegrationUtils;
import java.io.InputStream;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.junit.Assert;

public class IntegrationTest {
    private static final Random random = new Random();
    private static final Path collectionPath = new Path("/shared/collections/trec/trec4-5_noCRFR.xml");
    private static final String tmpPrefix = "tmp-" + IntegrationTest.class.getCanonicalName() + "-" + random.nextInt(10000);
    private static final String mappingFile = tmpPrefix + "-mapping.dat";

    @org.junit.Test
    public void runTests() throws Exception {
        this.testDocnoMapping();
        this.testDemoCountDocs();
        this.testForwardIndex();
    }

    private void testDocnoMapping() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + collectionPath, "-docnoMapping=" + mappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        TrecDocnoMapping mapping = new TrecDocnoMapping();
        mapping.loadMapping(new Path(mappingFile), fs);
        Assert.assertEquals((Object)"FBIS3-1", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"LA061490-0139", (Object)mapping.getDocid(400000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("FBIS3-1"));
        Assert.assertEquals((long)400000L, (long)mapping.getDocno("LA061490-0139"));
    }

    private void testDemoCountDocs() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        String output = tmpPrefix + "-cnt";
        String records = tmpPrefix + "-records.txt";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), CountTrecDocuments.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + collectionPath, "-output=" + output, "-docnoMapping=" + mappingFile, "-countOutput=" + records};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        LineReader reader = new LineReader((InputStream)fs.open(new Path(records)));
        Text str = new Text();
        reader.readLine(str);
        reader.close();
        Assert.assertEquals((long)472525L, (long)Integer.parseInt(str.toString()));
    }

    private void testForwardIndex() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        String index = tmpPrefix + "-findex.dat";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecForwardIndexBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + collectionPath, "-index=" + index, "-docnoMapping=" + mappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        TrecForwardIndex findex = new TrecForwardIndex();
        findex.loadIndex(new Path(index), new Path(mappingFile), fs);
        Assert.assertTrue((boolean)findex.getDocument(1).getContent().contains("Newspapers in the Former Yugoslav Republic"));
        Assert.assertTrue((boolean)findex.getDocument("FBIS3-1").getContent().contains("Newspapers in the Former Yugoslav Republic"));
        Assert.assertEquals((long)1L, (long)findex.getFirstDocno());
        Assert.assertEquals((long)472525L, (long)findex.getLastDocno());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(IntegrationTest.class);
    }
}

