/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.collection.trecweb;

import com.google.common.base.Joiner;
import edu.umd.cloud9.collection.trecweb.Gov2DocnoMapping;
import edu.umd.cloud9.collection.trecweb.RepackTrecWebCollection;
import edu.umd.cloud9.collection.trecweb.TrecWebDocnoMappingBuilder;
import edu.umd.cloud9.collection.trecweb.TrecWebDocumentInputFormat;
import edu.umd.cloud9.collection.trecweb.Wt10gDocnoMapping;
import edu.umd.cloud9.integration.IntegrationUtils;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;

public class IntegrationTest {
    private static final Random random = new Random();
    private static final Path wt10gPath = new Path("/shared/collections/wt10g/collection.raw");
    private static final Path gov2Path = new Path("/shared/collections/gov2/collection.raw/gov2-corpus");
    private static final String tmpPrefix = "tmp-" + IntegrationTest.class.getCanonicalName() + "-" + random.nextInt(10000);

    @org.junit.Test
    public void testWt10gDocnoMappingRepacked() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(wt10gPath));
        String repackedCollection = tmpPrefix + "-wt10g-repacked";
        String wt10gMappingFile = tmpPrefix + "-wt10g-mapping-repacked.dat";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), RepackTrecWebCollection.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + wt10gPath, "-output=" + repackedCollection, "-compressionType=block"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecWebDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + repackedCollection, "-docnoMapping=" + wt10gMappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        Wt10gDocnoMapping mapping = new Wt10gDocnoMapping();
        mapping.loadMapping(new Path(wt10gMappingFile), fs);
        Assert.assertEquals((Object)"WTX001-B01-1", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"WTX062-B34-37", (Object)mapping.getDocid(1000000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("WTX001-B01-1"));
        Assert.assertEquals((long)1000000L, (long)mapping.getDocno("WTX062-B34-37"));
    }

    @org.junit.Test
    public void testGov2DocnoMappingRepacked() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(gov2Path));
        String repackedCollection = tmpPrefix + "-gov2-repacked";
        String gov2MappingFile = tmpPrefix + "-gov2-mapping-repacked.dat";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), RepackTrecWebCollection.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + gov2Path, "-output=" + repackedCollection, "-compressionType=block"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecWebDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + repackedCollection, "-docnoMapping=" + gov2MappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        Gov2DocnoMapping mapping = new Gov2DocnoMapping();
        mapping.loadMapping(new Path(gov2MappingFile), fs);
        Assert.assertEquals((Object)"GX000-00-0000000", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"GX210-38-0737901", (Object)mapping.getDocid(20000000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("GX000-00-0000000"));
        Assert.assertEquals((long)20000000L, (long)mapping.getDocno("GX210-38-0737901"));
    }

    @org.junit.Test
    public void testWt10gDocnoMapping() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(wt10gPath));
        String wt10gMappingFile = tmpPrefix + "-wt10g-mapping.dat";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecWebDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + wt10gPath, "-inputFormat=" + TrecWebDocumentInputFormat.class.getCanonicalName(), "-docnoMapping=" + wt10gMappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        Wt10gDocnoMapping mapping = new Wt10gDocnoMapping();
        mapping.loadMapping(new Path(wt10gMappingFile), fs);
        Assert.assertEquals((Object)"WTX001-B01-1", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"WTX062-B34-37", (Object)mapping.getDocid(1000000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("WTX001-B01-1"));
        Assert.assertEquals((long)1000000L, (long)mapping.getDocno("WTX062-B34-37"));
    }

    @org.junit.Test
    public void testGov2DocnoMapping() throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(gov2Path));
        String gov2MappingFile = tmpPrefix + "-gov2-mapping.dat";
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), TrecWebDocnoMappingBuilder.class.getCanonicalName(), "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-collection=" + gov2Path, "-inputFormat=" + TrecWebDocumentInputFormat.class.getCanonicalName(), "-docnoMapping=" + gov2MappingFile};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        Gov2DocnoMapping mapping = new Gov2DocnoMapping();
        mapping.loadMapping(new Path(gov2MappingFile), fs);
        Assert.assertEquals((Object)"GX000-00-0000000", (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)"GX210-38-0737901", (Object)mapping.getDocid(20000000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno("GX000-00-0000000"));
        Assert.assertEquals((long)20000000L, (long)mapping.getDocno("GX210-38-0737901"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(IntegrationTest.class);
    }
}

