/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.collection.wikipedia;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMapping;
import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMappingBuilder;
import edu.umd.cloud9.integration.IntegrationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;

public class WikipediaBasicIntegrationTest {
    private static final Random random = new Random();
    private static final String tmpPrefix = "tmp-" + WikipediaBasicIntegrationTest.class.getCanonicalName() + "-" + random.nextInt(10000);

    public void testWikiDocnoMapping(String language, String input, String docid1, String docid2, int numDisamb, int numArticles, int total) throws Exception {
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(new Path(input)));
        String mappingFile = tmpPrefix + "-" + language + "wiki-mapping.dat";
        ArrayList jars = Lists.newArrayList();
        jars.add(IntegrationUtils.getJar("lib", "bliki-core"));
        jars.add(IntegrationUtils.getJar("lib", "guava"));
        jars.add(IntegrationUtils.getJar("lib", "dsiutils"));
        jars.add(IntegrationUtils.getJar("lib", "fastutil"));
        jars.add(IntegrationUtils.getJar("lib", "sux4j"));
        jars.add(IntegrationUtils.getJar("lib", "commons-collections"));
        jars.add(IntegrationUtils.getJar("lib", "commons-lang"));
        jars.add(IntegrationUtils.getJar("lib", "tools"));
        jars.add(IntegrationUtils.getJar("lib", "maxent"));
        jars.add(IntegrationUtils.getJar("dist", "cloud9"));
        String libjars = String.format("-libjars=%s", Joiner.on((String)",").join((Iterable)jars));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), WikipediaDocnoMappingBuilder.class.getCanonicalName(), libjars, "-input=" + input, "-output_file=" + mappingFile, "-wiki_language=" + language};
        List<Integer> counts = IntegrationUtils.execWiki(Joiner.on((String)" ").join(args));
        WikipediaDocnoMapping mapping = new WikipediaDocnoMapping();
        mapping.loadMapping(new Path(mappingFile), fs);
        System.out.println("DISAMBIGUATION = " + numDisamb + "; ARTICLE = " + numArticles + "; TOTAL = " + total);
        System.out.println("DOCNO 0 = " + mapping.getDocid(1));
        System.out.println("DOCNO 100000 = " + mapping.getDocid(100000));
        Assert.assertEquals((Object)docid1, (Object)mapping.getDocid(1));
        Assert.assertEquals((Object)docid2, (Object)mapping.getDocid(100000));
        Assert.assertEquals((long)1L, (long)mapping.getDocno(docid1));
        Assert.assertEquals((long)100000L, (long)mapping.getDocno(docid2));
        Assert.assertEquals((long)numDisamb, (long)counts.get(0).intValue());
        Assert.assertEquals((long)numArticles, (long)counts.get(1).intValue());
        Assert.assertEquals((long)total, (long)counts.get(2).intValue());
    }

    @org.junit.Test
    public void testAllWikis() throws Exception {
        this.testWikiDocnoMapping("en", "/shared/collections/wikipedia/raw/enwiki-20121201-pages-articles", "12", "189362", 123666, 4033137, 0xC5C8CC);
        this.testWikiDocnoMapping("cs", "/shared/collections/wikipedia/raw/cswiki-20121215-pages-articles.xml", "4", "344433", 7800, 248999, 497398);
        this.testWikiDocnoMapping("de", "/shared/collections/wikipedia/raw/dewiki-20121215-pages-articles.xml", "1", "297141", 174678, 1326111, 3001626);
        this.testWikiDocnoMapping("es", "/shared/collections/wikipedia/raw/eswiki-20121130-pages-articles.xml", "7", "358642", 36669, 1092193, 2611748);
        this.testWikiDocnoMapping("ar", "/shared/collections/wikipedia/raw/arwiki-20121218-pages-articles.xml", "7", "572997", 3789, 237860, 529641);
        this.testWikiDocnoMapping("zh", "/shared/collections/wikipedia/raw/zhwiki-20121210-pages-articles.xml", "13", "456258", 17992, 602267, 2067973);
        this.testWikiDocnoMapping("tr", "/shared/collections/wikipedia/raw/trwiki-20121217-pages-articles.xml", "5", "432151", 5938, 240952, 589118);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(WikipediaBasicIntegrationTest.class);
    }
}

