/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.collection.wikipedia;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.umd.cloud9.collection.wikipedia.RepackWikipedia;
import edu.umd.cloud9.collection.wikipedia.WikipediaDocnoMappingBuilder;
import edu.umd.cloud9.collection.wikipedia.graph.ExtractWikipediaLinkGraph;
import edu.umd.cloud9.example.bfs.EncodeBfsGraph;
import edu.umd.cloud9.example.bfs.IterateBfs;
import edu.umd.cloud9.integration.IntegrationUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class WikipediaBfsIntegrationTest {
    private static final Random random = new Random();
    private static final String tmpPrefix = "tmp-" + WikipediaBfsIntegrationTest.class.getCanonicalName() + "-" + random.nextInt(10000);

    @Test
    public void tesBfs() throws Exception {
        String input = "/shared/collections/wikipedia/raw/enwiki-20121201-pages-articles";
        Configuration conf = IntegrationUtils.getBespinConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(new Path(input)));
        String mappingFile = tmpPrefix + "-enwiki-mapping.dat";
        ArrayList jars = Lists.newArrayList();
        jars.add(IntegrationUtils.getJar("lib", "bliki-core"));
        jars.add(IntegrationUtils.getJar("lib", "guava"));
        jars.add(IntegrationUtils.getJar("lib", "dsiutils"));
        jars.add(IntegrationUtils.getJar("lib", "fastutil"));
        jars.add(IntegrationUtils.getJar("lib", "sux4j"));
        jars.add(IntegrationUtils.getJar("lib", "commons-collections"));
        jars.add(IntegrationUtils.getJar("lib", "commons-lang"));
        jars.add(IntegrationUtils.getJar("lib", "tools"));
        jars.add(IntegrationUtils.getJar("lib", "maxent"));
        jars.add(IntegrationUtils.getJar("dist", "cloud9"));
        String libjars = String.format("-libjars=%s", Joiner.on((String)",").join((Iterable)jars));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), WikipediaDocnoMappingBuilder.class.getCanonicalName(), libjars, "-input=" + input, "-output_file=" + mappingFile, "-keep_all"};
        Map<String, Integer> values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"TOTAL"));
        Assert.assertEquals((long)0xC5C8CCL, (long)values.get("TOTAL").intValue());
        String repackedWiki = tmpPrefix + "-enwiki.block";
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), RepackWikipedia.class.getCanonicalName(), libjars, "-input=" + input, "-mapping_file=" + mappingFile, "-output=" + repackedWiki, "-compression_type=block"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"TOTAL"));
        Assert.assertEquals((long)0xC5C8CCL, (long)values.get("TOTAL").intValue());
        String wikiEdges = tmpPrefix + "-enwiki.edges";
        String wikiAdj = tmpPrefix + "-enwiki.adj";
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), ExtractWikipediaLinkGraph.class.getCanonicalName(), libjars, "-input=" + repackedWiki, "-edges_output=" + wikiEdges, "-adjacency_list_output=" + wikiAdj, "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"EDGES", (Object)"TOTAL_VERTICES", (Object)"VERTICES_WITH_OUTLINKS"));
        Assert.assertEquals((long)121762273L, (long)values.get("EDGES").intValue());
        Assert.assertEquals((long)0xC5C8CCL, (long)values.get("TOTAL_VERTICES").intValue());
        Assert.assertEquals((long)10813673L, (long)values.get("VERTICES_WITH_OUTLINKS").intValue());
        String bfsBase = tmpPrefix + "-enwiki.bfs";
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), EncodeBfsGraph.class.getCanonicalName(), libjars, "-input=" + wikiAdj, "-output=" + bfsBase + "/iter0000", "-src=12"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), IterateBfs.class.getCanonicalName(), libjars, "-input=" + bfsBase + "/iter0000", "-output=" + bfsBase + "/iter0001", "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"ReachableInReducer"));
        Assert.assertEquals((long)573L, (long)values.get("ReachableInReducer").intValue());
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), IterateBfs.class.getCanonicalName(), libjars, "-input=" + bfsBase + "/iter0001", "-output=" + bfsBase + "/iter0002", "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"ReachableInReducer"));
        Assert.assertEquals((long)37733L, (long)values.get("ReachableInReducer").intValue());
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), IterateBfs.class.getCanonicalName(), libjars, "-input=" + bfsBase + "/iter0002", "-output=" + bfsBase + "/iter0003", "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"ReachableInReducer"));
        Assert.assertEquals((long)845452L, (long)values.get("ReachableInReducer").intValue());
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), IterateBfs.class.getCanonicalName(), libjars, "-input=" + bfsBase + "/iter0003", "-output=" + bfsBase + "/iter0004", "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"ReachableInReducer"));
        Assert.assertEquals((long)3596247L, (long)values.get("ReachableInReducer").intValue());
        args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), IterateBfs.class.getCanonicalName(), libjars, "-input=" + bfsBase + "/iter0004", "-output=" + bfsBase + "/iter0005", "-num_partitions=10"};
        values = IntegrationUtils.execKeyValueExtractor(Joiner.on((String)" ").join(args), (Set<String>)ImmutableSet.of((Object)"ReachableInReducer"));
        Assert.assertEquals((long)5236564L, (long)values.get("ReachableInReducer").intValue());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(WikipediaBfsIntegrationTest.class);
    }
}

