/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.example.bigram;

import com.google.common.base.Joiner;
import edu.umd.cloud9.example.bigram.BigramRelativeFrequency;
import edu.umd.cloud9.example.bigram.BigramRelativeFrequencyJson;
import edu.umd.cloud9.example.bigram.BigramRelativeFrequencyTuple;
import edu.umd.cloud9.integration.IntegrationUtils;
import edu.umd.cloud9.io.pair.PairOfStrings;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.junit.Assert;
import org.junit.Test;

public class BigramRelativeFrequencyTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Random random = new Random();
    private static final Path collectionPath = new Path("data/bible+shakes.nopunc.gz");
    private static final String tmpPrefix = "tmp-" + BigramRelativeFrequencyTest.class.getCanonicalName() + "-" + random.nextInt(10000);

    @Test
    public void testBigramRelativeFrequencyBase() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), BigramRelativeFrequency.class.getCanonicalName(), "-D fs.defaultFS=file:/// -D mapreduce.framework.name=local -D mapreduce.jobtracker.address=local -D mapreduce.cluster.local.dir=/tmp/mapred/local -D mapreduce.cluster.temp.dir=/tmp/mapred/temp -D mapreduce.jobtracker.staging.root.dir=/tmp/mapred/staging -D mapreduce.jobtracker.system.dir=/tmp/mapred/system", "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-input", collectionPath.toString(), "-output", tmpPrefix + "-base", "-numReducers", "1"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(tmpPrefix + "-base/part-r-00000"))});
        PairOfStrings pair = new PairOfStrings();
        FloatWritable f = new FloatWritable();
        reader.next((Writable)pair, (Writable)f);
        Assert.assertEquals((Object)"&c", (Object)pair.getLeftElement());
        Assert.assertEquals((Object)"*", (Object)pair.getRightElement());
        Assert.assertEquals((double)17.0, (double)f.get(), (double)1.0E-5);
        for (int i = 0; i < 100; ++i) {
            reader.next((Writable)pair, (Writable)f);
        }
        Assert.assertEquals((Object)"'dear", (Object)pair.getLeftElement());
        Assert.assertEquals((Object)"*", (Object)pair.getRightElement());
        Assert.assertEquals((double)2.0, (double)f.get(), (double)1.0E-5);
        reader.next((Writable)pair, (Writable)f);
        Assert.assertEquals((Object)"'dear", (Object)pair.getLeftElement());
        Assert.assertEquals((Object)"lord", (Object)pair.getRightElement());
        Assert.assertEquals((double)1.0, (double)f.get(), (double)1.0E-5);
        reader.close();
    }

    @Test
    public void testBigramRelativeFrequencyJson() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), BigramRelativeFrequencyJson.class.getCanonicalName(), "-D fs.defaultFS=file:/// -D mapreduce.framework.name=local -D mapreduce.jobtracker.address=local -D mapreduce.cluster.local.dir=/tmp/mapred/local -D mapreduce.cluster.temp.dir=/tmp/mapred/temp -D mapreduce.jobtracker.staging.root.dir=/tmp/mapred/staging -D mapreduce.jobtracker.system.dir=/tmp/mapred/system", "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-input", collectionPath.toString(), "-output", tmpPrefix + "-json", "-numReducers", "1"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(tmpPrefix + "-json/part-r-00000"))});
        BigramRelativeFrequencyJson.MyTuple json = new BigramRelativeFrequencyJson.MyTuple();
        FloatWritable f = new FloatWritable();
        reader.next((Writable)json, (Writable)f);
        Assert.assertEquals((Object)"&c", (Object)json.getJsonObject().get("Left").getAsString());
        Assert.assertEquals((Object)"*", (Object)json.getJsonObject().get("Right").getAsString());
        Assert.assertEquals((double)17.0, (double)f.get(), (double)1.0E-5);
        for (int i = 0; i < 100; ++i) {
            reader.next((Writable)json, (Writable)f);
        }
        Assert.assertEquals((Object)"'dear", (Object)json.getJsonObject().get("Left").getAsString());
        Assert.assertEquals((Object)"*", (Object)json.getJsonObject().get("Right").getAsString());
        Assert.assertEquals((double)2.0, (double)f.get(), (double)1.0E-5);
        reader.next((Writable)json, (Writable)f);
        Assert.assertEquals((Object)"'dear", (Object)json.getJsonObject().get("Left").getAsString());
        Assert.assertEquals((Object)"lord", (Object)json.getJsonObject().get("Right").getAsString());
        Assert.assertEquals((double)1.0, (double)f.get(), (double)1.0E-5);
        reader.close();
    }

    @Test
    public void testBigramRelativeFrequencyTuple() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), BigramRelativeFrequencyTuple.class.getCanonicalName(), "-D fs.defaultFS=file:/// -D mapreduce.framework.name=local -D mapreduce.jobtracker.address=local -D mapreduce.cluster.local.dir=/tmp/mapred/local -D mapreduce.cluster.temp.dir=/tmp/mapred/temp -D mapreduce.jobtracker.staging.root.dir=/tmp/mapred/staging -D mapreduce.jobtracker.system.dir=/tmp/mapred/system", "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-input", collectionPath.toString(), "-output", tmpPrefix + "-tuple", "-numReducers", "1"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(tmpPrefix + "-tuple/part-r-00000"))});
        Tuple tuple = TUPLE_FACTORY.newTuple();
        FloatWritable f = new FloatWritable();
        reader.next((Writable)tuple, (Writable)f);
        Assert.assertEquals((Object)"&c", (Object)tuple.get(0).toString());
        Assert.assertEquals((Object)"*", (Object)tuple.get(1).toString());
        Assert.assertEquals((double)17.0, (double)f.get(), (double)1.0E-5);
        for (int i = 0; i < 100; ++i) {
            reader.next((Writable)tuple, (Writable)f);
        }
        Assert.assertEquals((Object)"'dear", (Object)tuple.get(0).toString());
        Assert.assertEquals((Object)"*", (Object)tuple.get(1).toString());
        Assert.assertEquals((double)2.0, (double)f.get(), (double)1.0E-5);
        reader.next((Writable)tuple, (Writable)f);
        Assert.assertEquals((Object)"'dear", (Object)tuple.get(0).toString());
        Assert.assertEquals((Object)"lord", (Object)tuple.get(1).toString());
        Assert.assertEquals((double)1.0, (double)f.get(), (double)1.0E-5);
        reader.close();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(BigramRelativeFrequencyTest.class);
    }
}

