/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.integration.example.ir;

import com.google.common.base.Joiner;
import edu.umd.cloud9.example.ir.BuildInvertedIndex;
import edu.umd.cloud9.integration.IntegrationUtils;
import edu.umd.cloud9.io.array.ArrayListWritable;
import edu.umd.cloud9.io.pair.PairOfInts;
import edu.umd.cloud9.io.pair.PairOfWritables;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;

public class InvertedIndexingTest {
    private static final Random random = new Random();
    private static final Path collectionPath = new Path("data/bible+shakes.nopunc.gz");
    private static final String tmpPrefix = "tmp-" + InvertedIndexingTest.class.getCanonicalName() + "-" + random.nextInt(10000);

    @org.junit.Test
    public void testInvertedIndexing() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(collectionPath));
        Object[] args = new String[]{"hadoop jar", IntegrationUtils.getJar("dist", "cloud9"), BuildInvertedIndex.class.getCanonicalName(), "-D fs.defaultFS=file:/// -D mapreduce.framework.name=local -D mapreduce.jobtracker.address=local -D mapreduce.cluster.local.dir=/tmp/mapred/local -D mapreduce.cluster.temp.dir=/tmp/mapred/temp -D mapreduce.jobtracker.staging.root.dir=/tmp/mapred/staging -D mapreduce.jobtracker.system.dir=/tmp/mapred/system", "-libjars=" + IntegrationUtils.getJar("lib", "guava"), "-input", collectionPath.toString(), "-output", tmpPrefix, "-numReducers", "1"};
        IntegrationUtils.exec(Joiner.on((String)" ").join(args));
        MapFile.Reader reader = new MapFile.Reader(new Path(tmpPrefix + "/part-r-00000"), conf, new SequenceFile.Reader.Option[0]);
        Text key = new Text();
        PairOfWritables value = new PairOfWritables();
        key.set("gold");
        reader.get((WritableComparable)key, value);
        Assert.assertEquals((long)584L, (long)((IntWritable)value.getLeftElement()).get());
        ArrayListWritable postings = (ArrayListWritable)value.getRightElement();
        Assert.assertEquals((long)584L, (long)((IntWritable)value.getLeftElement()).get());
        Assert.assertEquals((long)5303L, (long)((PairOfInts)postings.get(0)).getLeftElement());
        Assert.assertEquals((long)684030L, (long)((PairOfInts)postings.get(100)).getLeftElement());
        Assert.assertEquals((long)1634312L, (long)((PairOfInts)postings.get(200)).getLeftElement());
        reader.close();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(InvertedIndexingTest.class);
    }
}

