/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class FileMerger
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(FileMerger.class);
    public static final Random RANDOM_GENERATOR = new Random();
    public static final int DEFAULT_RANDOM_STRING_LENGTH = 20;
    public static final String PATH_INDICATOR = "path";
    public static final String INTEGER_INDICATOR = "int";
    public static final String HELP_OPTION = "help";
    public static final String INPUT_OPTION = "input";
    public static final String OUTPUT_OPTION = "output";
    public static final String MAPPER_OPTION = "mapper";
    public static final String REDUCER_OPTION = "reducer";
    public static final String MERGE = "merge-tmp-dir";
    public static final String LOCAL_MERGE_OPTION = "localmerge";
    public static final boolean LOCAL_MERGE = false;
    public static final String DELETE_SOURCE_OPTION = "deletesource";
    public static final boolean DELETE_SOURCE = false;
    public static final String TEXT_FILE_INPUT_FORMAT = "textformat";
    public static final boolean TEXT_FILE_INPUT = false;
    public static final String FILE_CONTENT_DELIMITER = "";

    public static String generateRandomString(int length) {
        return new BigInteger(length * 4, RANDOM_GENERATOR).toString(32);
    }

    public static String generateRandomString() {
        return FileMerger.generateRandomString(20);
    }

    public static Path mergeTextFiles(Configuration configuration, String inputFiles, String outputFile, int numberOfMappers, boolean deleteSource) throws IOException {
        if (numberOfMappers <= 0) {
            return FileMerger.mergeTextFiles(configuration, inputFiles, outputFile, deleteSource, false);
        }
        return FileMerger.mergeFilesDistribute(configuration, inputFiles, outputFile, numberOfMappers, LongWritable.class, Text.class, TextInputFormat.class, TextOutputFormat.class, deleteSource, false);
    }

    public static Path mergeTextFiles(Configuration configuration, String inputFiles, String outputFile, int numberOfMappers, boolean deleteSource, boolean deleteDestinationFileIfExist) throws IOException {
        if (numberOfMappers <= 0) {
            return FileMerger.mergeTextFiles(configuration, inputFiles, outputFile, deleteSource, deleteDestinationFileIfExist);
        }
        return FileMerger.mergeFilesDistribute(configuration, inputFiles, outputFile, numberOfMappers, LongWritable.class, Text.class, TextInputFormat.class, TextOutputFormat.class, deleteSource, deleteDestinationFileIfExist);
    }

    private static Path mergeTextFiles(Configuration configuration, String inputFiles, String outputFile, boolean deleteSource, boolean deleteDestinationFileIfExist) throws IOException {
        JobConf conf = new JobConf(configuration, FileMerger.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = new Path(inputFiles);
        Path outputPath = new Path(outputFile);
        if (deleteDestinationFileIfExist) {
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, false);
                sLogger.info((Object)"Warning: remove destination file since it already exists...");
            }
        } else {
            Preconditions.checkArgument((!fs.exists(outputPath) ? 1 : 0) != 0, (Object)new IOException("Destination file already exists..."));
        }
        FileUtil.copyMerge((FileSystem)fs, (Path)inputPath, (FileSystem)fs, (Path)outputPath, (boolean)deleteSource, (Configuration)conf, (String)FILE_CONTENT_DELIMITER);
        sLogger.info((Object)("Successfully merge " + inputPath.toString() + " to " + outputFile));
        return outputPath;
    }

    public static Path mergeSequenceFiles(Configuration configuration, String inputFiles, String outputFile, int numberOfMappers, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass, boolean deleteSource) throws IOException, InstantiationException, IllegalAccessException {
        if (numberOfMappers <= 0) {
            return FileMerger.mergeSequenceFiles(configuration, inputFiles, outputFile, keyClass, valueClass, deleteSource, false);
        }
        return FileMerger.mergeFilesDistribute(configuration, inputFiles, outputFile, numberOfMappers, keyClass, valueClass, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, deleteSource, false);
    }

    public static Path mergeSequenceFiles(Configuration configuration, String inputFiles, String outputFile, int numberOfMappers, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass, boolean deleteSource, boolean deleteDestinationFileIfExist) throws IOException, InstantiationException, IllegalAccessException {
        if (numberOfMappers <= 0) {
            return FileMerger.mergeSequenceFiles(configuration, inputFiles, outputFile, keyClass, valueClass, deleteSource, deleteDestinationFileIfExist);
        }
        return FileMerger.mergeFilesDistribute(configuration, inputFiles, outputFile, numberOfMappers, keyClass, valueClass, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, deleteSource, deleteDestinationFileIfExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path mergeSequenceFiles(Configuration configuration, String inputFiles, String outputFile, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass, boolean deleteSource, boolean deleteDestinationFileIfExist) throws IOException, InstantiationException, IllegalAccessException {
        JobConf conf = new JobConf(configuration, FileMerger.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = new Path(inputFiles);
        Path outputPath = new Path(outputFile);
        if (deleteDestinationFileIfExist) {
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, false);
                sLogger.info((Object)"Warning: remove destination file since it already exists...");
            }
        } else {
            Preconditions.checkArgument((!fs.exists(outputPath) ? 1 : 0) != 0, (Object)new IOException("Destination file already exists..."));
        }
        FileStatus[] fileStatuses = fs.globStatus(inputPath);
        SequenceFile.Reader sequenceFileReader = null;
        SequenceFile.Writer sequenceFileWriter = null;
        Writable key = keyClass.newInstance();
        Writable value = valueClass.newInstance();
        try {
            sequenceFileWriter = new SequenceFile.Writer(fs, (Configuration)conf, outputPath, keyClass, valueClass);
            for (FileStatus fileStatus : fileStatuses) {
                sLogger.info((Object)("Openning file " + fileStatus.getPath() + "..."));
                sequenceFileReader = new SequenceFile.Reader(fs, fileStatus.getPath(), (Configuration)conf);
                while (sequenceFileReader.next(key, value)) {
                    sequenceFileWriter.append(key, value);
                }
                if (!deleteSource) continue;
                fs.deleteOnExit(fileStatus.getPath());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(sequenceFileReader);
            IOUtils.closeStream(sequenceFileWriter);
            throw throwable;
        }
        IOUtils.closeStream(sequenceFileReader);
        IOUtils.closeStream((Closeable)sequenceFileWriter);
        sLogger.info((Object)("Successfully merge " + inputPath.toString() + " to " + outputFile));
        return outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path mergeFilesDistribute(Configuration configuration, String inputFiles, String outputFile, int numberOfMappers, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass, Class<? extends FileInputFormat> fileInputClass, Class<? extends FileOutputFormat> fileOutputClass, boolean deleteSource, boolean deleteDestinationFileIfExist) throws IOException {
        JobConf conf = new JobConf(configuration, FileMerger.class);
        conf.setJobName(FileMerger.class.getSimpleName());
        FileSystem fs = FileSystem.get((Configuration)conf);
        sLogger.info((Object)("Tool: " + FileMerger.class.getSimpleName()));
        sLogger.info((Object)(" - merge files from: " + inputFiles));
        sLogger.info((Object)(" - merge files to: " + outputFile));
        conf.setNumMapTasks(numberOfMappers);
        conf.setNumReduceTasks(1);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setMapOutputKeyClass(keyClass);
        conf.setMapOutputValueClass(valueClass);
        conf.setOutputKeyClass(keyClass);
        conf.setOutputValueClass(valueClass);
        conf.setInputFormat(fileInputClass);
        conf.setOutputFormat(fileOutputClass);
        Path inputPath = new Path(inputFiles);
        Path mergePath = new Path(inputPath.getParent().toString() + "/" + MERGE + FileMerger.generateRandomString());
        Preconditions.checkArgument((!fs.exists(mergePath) ? 1 : 0) != 0, (Object)new IOException("Intermediate merge directory already exists..."));
        Path outputPath = new Path(outputFile);
        if (deleteDestinationFileIfExist) {
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, false);
                sLogger.info((Object)"Warning: remove destination file since it already exists...");
            }
        } else {
            Preconditions.checkArgument((!fs.exists(outputPath) ? 1 : 0) != 0, (Object)new IOException("Destination file already exists..."));
        }
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)mergePath);
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        try {
            long startTime = System.currentTimeMillis();
            RunningJob job = JobClient.runJob((JobConf)conf);
            sLogger.info((Object)("Merge Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
            fs.rename(new Path(mergePath.toString() + "/" + "part-00000"), outputPath);
            if (deleteSource) {
                for (FileStatus fileStatus : fs.globStatus(inputPath)) {
                    fs.deleteOnExit(fileStatus.getPath());
                }
            }
        }
        finally {
            fs.delete(mergePath, true);
        }
        sLogger.info((Object)("Successfully merge " + inputFiles.toString() + " to " + outputFile));
        return outputPath;
    }

    public int run(String[] args) throws IOException {
        Options options = new Options();
        options.addOption(HELP_OPTION, false, "print the help message");
        OptionBuilder.withArgName((String)PATH_INDICATOR);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input file or directory");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)PATH_INDICATOR);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output file");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)INTEGER_INDICATOR);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of mappers (default to 0 and hence local merge mode, set to positive value to enable cluster merge mode)");
        options.addOption(OptionBuilder.create((String)MAPPER_OPTION));
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"assign value for given property");
        options.addOption(OptionBuilder.create((String)"D"));
        options.addOption(TEXT_FILE_INPUT_FORMAT, false, "input file in sequence format");
        options.addOption(DELETE_SOURCE_OPTION, false, "delete sources after merging");
        int mapperTasks = 0;
        boolean deleteSource = false;
        boolean textFileFormat = false;
        String inputPath = FILE_CONTENT_DELIMITER;
        String outputPath = FILE_CONTENT_DELIMITER;
        GenericOptionsParser genericOptionsParser = new GenericOptionsParser(args);
        Configuration configuration = genericOptionsParser.getConfiguration();
        GnuParser parser = new GnuParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP_OPTION)) {
                formatter.printHelp(FileMerger.class.getName(), options);
                System.exit(0);
            }
            if (!line.hasOption(INPUT_OPTION)) {
                throw new ParseException("Parsing failed due to input not initialized...");
            }
            inputPath = line.getOptionValue(INPUT_OPTION);
            if (!line.hasOption(OUTPUT_OPTION)) {
                throw new ParseException("Parsing failed due to output not initialized...");
            }
            outputPath = line.getOptionValue(OUTPUT_OPTION);
            if (line.hasOption(MAPPER_OPTION) && (mapperTasks = Integer.parseInt(line.getOptionValue(MAPPER_OPTION))) <= 0) {
                sLogger.info((Object)"Warning: mapper is not positive, merge in local model...");
                mapperTasks = 0;
            }
            if (line.hasOption(DELETE_SOURCE_OPTION)) {
                deleteSource = true;
            }
            if (line.hasOption(TEXT_FILE_INPUT_FORMAT)) {
                textFileFormat = true;
            }
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
            formatter.printHelp(FileMerger.class.getName(), options);
            System.exit(0);
        }
        catch (NumberFormatException nfe) {
            System.err.println(nfe.getMessage());
            System.exit(0);
        }
        try {
            FileMerger.merge(configuration, inputPath, outputPath, mapperTasks, textFileFormat, deleteSource);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return 0;
    }

    public static Path merge(Configuration configuration, String inputPath, String outputPath, int mapperTasks, boolean textFileFormat, boolean deleteSource) throws IOException, InstantiationException, IllegalAccessException {
        Class keyClass = LongWritable.class;
        Class valueClass = Text.class;
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        if (!textFileFormat) {
            FileStatus[] fileStatus = fs.globStatus(new Path(inputPath));
            Preconditions.checkArgument((fileStatus.length > 0 ? 1 : 0) != 0, (Object)"Invalid input path...");
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, fileStatus[fileStatus.length - 1].getPath(), fs.getConf());
            try {
                keyClass = reader.getKeyClass();
                valueClass = reader.getValueClass();
                sLogger.info((Object)("Key type: " + keyClass.toString()));
                sLogger.info((Object)("Value type: " + valueClass.toString()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error in loading key/value class");
            }
            reader.close();
        }
        if (textFileFormat) {
            return FileMerger.mergeTextFiles(configuration, inputPath, outputPath, mapperTasks, deleteSource);
        }
        return FileMerger.mergeSequenceFiles(configuration, inputPath, outputPath, mapperTasks, keyClass, valueClass, deleteSource);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new FileMerger(), (String[])args);
        System.exit(res);
    }
}

