/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.umd.cloud9.io.JsonWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class JsonWritableTest {
    @org.junit.Test
    public void testSerialize1() throws Exception {
        JsonWritable obj1 = new JsonWritable();
        obj1.getJsonObject().addProperty("JSON", "Hello, World!");
        byte[] bytes = obj1.serialize();
        JsonWritable obj2 = JsonWritable.create(bytes);
        Assert.assertEquals((Object)"{\"JSON\":\"Hello, World!\"}", (Object)obj2.getJsonObject().toString());
    }

    @org.junit.Test
    public void testSerialize2() throws Exception {
        JsonWritable obj1 = new JsonWritable();
        obj1.getJsonObject().addProperty("JSON", "'tis");
        byte[] bytes = obj1.serialize();
        JsonWritable obj2 = JsonWritable.create(bytes);
        Assert.assertEquals((Object)"{\"JSON\":\"'tis\"}", (Object)obj2.getJsonObject().toString());
    }

    @org.junit.Test
    public void testSerialize() throws Exception {
        JsonWritable w = new JsonWritable();
        JsonObject obj = w.getJsonObject();
        obj.addProperty("firstName", "John");
        obj.addProperty("lastName", "Smith");
        JsonObject address = new JsonObject();
        address.addProperty("streetAddress", "21 2nd Street");
        address.addProperty("city", "New York");
        address.addProperty("state", "NY");
        address.addProperty("postalCode", (Number)10021);
        JsonArray phoneNumbers = new JsonArray();
        phoneNumbers.add((JsonElement)new JsonPrimitive("212 555-1234"));
        phoneNumbers.add((JsonElement)new JsonPrimitive("646 555-4567"));
        obj.add("address", (JsonElement)address);
        obj.add("phoneNumbers", (JsonElement)phoneNumbers);
        byte[] bytes = w.serialize();
        JsonWritable w2 = JsonWritable.create(bytes);
        String s = "{\"firstName\":\"John\",\"lastName\":\"Smith\",\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":10021},\"phoneNumbers\":[\"212 555-1234\",\"646 555-4567\"]}";
        Assert.assertEquals((Object)s, (Object)w2.getJsonObject().toString());
        JsonObject obj2 = w2.getJsonObject();
        Assert.assertEquals((Object)"John", (Object)obj2.get("firstName").getAsString());
        Assert.assertEquals((Object)"Smith", (Object)obj2.get("lastName").getAsString());
        Assert.assertEquals((Object)"New York", (Object)obj2.getAsJsonObject("address").get("city").getAsString());
        Assert.assertEquals((long)2L, (long)obj2.getAsJsonArray("phoneNumbers").size());
        Assert.assertEquals((Object)"212 555-1234", (Object)((JsonPrimitive)obj2.getAsJsonArray("phoneNumbers").get(0)).getAsString());
    }

    @org.junit.Test
    public void testRewrite() throws Exception {
        String s1 = "{\"JSON\":\"Hello, World!\"}";
        String s2 = "{\"JSON\":\"Hello!\"}";
        JsonWritable obj = new JsonWritable(s1);
        Assert.assertEquals((Object)obj.getJsonObject().toString(), (Object)s1);
        byte[] s2Bytes = s2.getBytes();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        dataOut.writeInt(s2Bytes.length);
        dataOut.write(s2Bytes);
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray()));
        obj.readFields(dataIn);
        Assert.assertEquals((Object)obj.getJsonObject().toString(), (Object)s2);
    }

    @org.junit.Test
    public void testOverwrite() throws Exception {
        JsonWritable obj = new JsonWritable();
        obj.getJsonObject().addProperty("field", "longer string");
        Assert.assertEquals((Object)"{\"field\":\"longer string\"}", (Object)obj.getJsonObject().toString());
        obj.getJsonObject().addProperty("field", "a");
        Assert.assertEquals((Object)"{\"field\":\"a\"}", (Object)obj.getJsonObject().toString());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(JsonWritableTest.class);
    }
}

