/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class ReadSequenceFile {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    private ReadSequenceFile() {
    }

    public static void main(String[] args) throws IOException {
        Path p;
        LocalFileSystem fs;
        boolean useLocal;
        if (args.length < 1) {
            System.out.println("args: [path] [max-num-of-records-per-file]");
            System.exit(-1);
        }
        String f = args[0];
        int max = Integer.MAX_VALUE;
        if (args.length >= 2) {
            max = Integer.parseInt(args[1]);
        }
        boolean bl = useLocal = args.length >= 3 && args[2].equals("local");
        if (useLocal) {
            System.out.println("Reading from local filesystem");
        }
        if ((fs = useLocal ? FileSystem.getLocal((Configuration)new Configuration()) : FileSystem.get((Configuration)new Configuration())).getFileStatus(p = new Path(f)).isDir()) {
            ReadSequenceFile.readSequenceFilesInDir(p, (FileSystem)fs, max);
        } else {
            ReadSequenceFile.readSequenceFile(p, (FileSystem)fs, max);
        }
    }

    private static int readSequenceFile(Path path, FileSystem fs, int max) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, fs.getConf());
        System.out.println("Reading " + path + "...\n");
        try {
            System.out.println("Key type: " + reader.getKeyClass().toString());
            System.out.println("Value type: " + reader.getValueClass().toString() + "\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Error: loading key/value class");
        }
        int n = 0;
        try {
            Object key = Tuple.class.isAssignableFrom(reader.getKeyClass()) ? TUPLE_FACTORY.newTuple() : (Writable)reader.getKeyClass().newInstance();
            Object value = Tuple.class.isAssignableFrom(reader.getValueClass()) ? TUPLE_FACTORY.newTuple() : (Writable)reader.getValueClass().newInstance();
            while (reader.next((Writable)key, (Writable)value)) {
                System.out.println("Record " + n);
                System.out.println("Key: " + key + "\nValue: " + value);
                System.out.println("----------------------------------------");
                if (++n < max) continue;
            }
            reader.close();
            System.out.println(n + " records read.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    private static int readSequenceFilesInDir(Path path, FileSystem fs, int max) {
        int n = 0;
        try {
            FileStatus[] stat = fs.listStatus(path);
            for (int i = 0; i < stat.length; ++i) {
                n += ReadSequenceFile.readSequenceFile(stat[i].getPath(), fs, max);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(n + " records read in total.");
        return n;
    }
}

