/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class Array2DOfDoublesWritable
implements Writable {
    double[][] array;

    public Array2DOfDoublesWritable() {
    }

    public Array2DOfDoublesWritable(double[][] array) {
        this.set(array);
    }

    public Array2DOfDoublesWritable(int row, int column) {
        this.array = new double[row][column];
        for (int i = 0; i < row; ++i) {
            this.array[row] = new double[column];
        }
    }

    public void readFields(DataInput in) throws IOException {
        int row = in.readInt();
        int col = in.readInt();
        this.array = new double[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.setValueAt(i, j, in.readDouble());
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getNumberOfRows());
        out.writeInt(this.getNumberOfCols());
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            for (int j = 0; j < this.getNumberOfCols(); ++j) {
                out.writeDouble(this.getValueAt(i, j));
            }
        }
    }

    public double[][] getClone() {
        return (double[][])this.array.clone();
    }

    public double[][] getArray() {
        return this.array;
    }

    public double getValueAt(int row, int col) {
        return this.array[row][col];
    }

    public void set(double[][] array) {
        int i;
        int row = array.length;
        int col = 0;
        for (i = 0; i < row; ++i) {
            if (array[i] == null) continue;
            col = Math.max(col, array[i].length);
        }
        this.array = array;
        for (i = 0; i < row; ++i) {
            if (array[i] == null) {
                array[i] = new double[col];
                continue;
            }
            if (array[i].length >= col) continue;
            double[] temp = new double[col];
            for (int j = 0; j < array[i].length; ++j) {
                temp[j] = array[i][j];
            }
            array[i] = temp;
        }
    }

    public void setValueAt(int row, int col, double f) {
        this.array[row][col] = f;
    }

    public int getNumberOfRows() {
        return this.array.length;
    }

    public int getNumberOfCols() {
        return this.array[0].length;
    }

    public String toString() {
        String s = "[";
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            for (int j = 0; j < this.getNumberOfCols() - 1; ++j) {
                s = s + this.getValueAt(i, j) + ", ";
            }
            s = s + this.getValueAt(i, this.getNumberOfCols() - 1) + "; ";
        }
        s = s + "]";
        return s;
    }
}

