/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import edu.umd.cloud9.io.array.Array2DOfFloatsWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Array2DOfFloatsWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        float[][] ia = new float[][]{{1.0f, 2.0f, 4.0f, 5.0f}, {3.0f}, null};
        Array2DOfFloatsWritable array2D = new Array2DOfFloatsWritable(ia);
        Assert.assertEquals((double)array2D.getValueAt(0, 1), (double)2.0, (double)1.0E-6);
        Assert.assertEquals((double)array2D.getValueAt(0, 3), (double)5.0, (double)1.0E-6);
        Assert.assertEquals((double)array2D.getValueAt(1, 0), (double)3.0, (double)1.0E-6);
        Assert.assertEquals((double)array2D.getValueAt(2, 0), (double)0.0, (double)1.0E-6);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        float[][] ia = new float[][]{{1.0f, 2.0f, 4.0f, 5.0f}, {3.0f}, null};
        Array2DOfFloatsWritable array2DA = new Array2DOfFloatsWritable(ia);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array2DA.write(dataOut);
        Array2DOfFloatsWritable array2DB = new Array2DOfFloatsWritable();
        array2DB.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((double)array2DB.getValueAt(0, 1), (double)2.0, (double)1.0E-6);
        Assert.assertEquals((double)array2DB.getValueAt(0, 3), (double)5.0, (double)1.0E-6);
        Assert.assertEquals((double)array2DB.getValueAt(1, 0), (double)3.0, (double)1.0E-6);
        Assert.assertEquals((double)array2DB.getValueAt(2, 0), (double)0.0, (double)1.0E-6);
    }

    @org.junit.Test
    public void testToString() {
        float[][] ia = new float[][]{{1.0f, 2.0f, 4.0f, 5.0f}, {3.0f}, null};
        Array2DOfFloatsWritable array2D = new Array2DOfFloatsWritable(ia);
        Assert.assertEquals((Object)array2D.toString(), (Object)"[1.0, 2.0, 4.0, 5.0; 3.0, 0.0, 0.0, 0.0; 0.0, 0.0, 0.0, 0.0; ]");
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Array2DOfFloatsWritableTest.class);
    }
}

