/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import edu.umd.cloud9.io.SequenceFileUtils;
import edu.umd.cloud9.io.array.ArrayListOfLongsWritable;
import java.io.IOException;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;

public class ArrayListOfLongsWritableTest {
    long neg_one = -1L;
    long zero = 0L;
    long one = 1L;
    long two = 2L;
    long three = 3L;
    long four = 4L;
    long five = 5L;
    long six = 6L;
    long seven = 7L;
    long nine = 9L;

    @org.junit.Test
    public void testToString() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfLongsWritable(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfLongsWritable(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfLongsWritable(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfLongsWritable(1, 12).toString());
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfLongsWritable().toString());
    }

    @org.junit.Test
    public void testReadWrite() throws IOException {
        ArrayListOfLongsWritable arr = new ArrayListOfLongsWritable();
        arr.add(0, 1L).add(1, 3L).add(2, 5L).add(3, 7L);
        Configuration conf = new Configuration();
        Path tmp = new Path("tmp");
        FileSystem.get((Configuration)conf).delete(tmp, true);
        try {
            SequenceFile.Writer w = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)tmp), SequenceFile.Writer.keyClass(IntWritable.class), SequenceFile.Writer.valueClass(ArrayListOfLongsWritable.class)});
            w.append((Writable)new IntWritable(1), (Writable)arr);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        List listOfKeysPairs = SequenceFileUtils.readFile(tmp);
        FileSystem.get((Configuration)conf).delete(tmp, true);
        Assert.assertTrue((listOfKeysPairs.size() == 1 ? 1 : 0) != 0);
        ArrayListOfLongsWritable arrRead = (ArrayListOfLongsWritable)listOfKeysPairs.get(0).getRightElement();
        Assert.assertEquals((long)4L, (long)arrRead.size());
        Assert.assertEquals((long)1L, (long)arrRead.get(0));
        Assert.assertEquals((long)3L, (long)arrRead.get(1));
        Assert.assertEquals((long)5L, (long)arrRead.get(2));
        Assert.assertEquals((long)7L, (long)arrRead.get(3));
        arrRead.remove(0);
        arrRead.remove(0);
        arrRead.remove(1);
        Assert.assertEquals((long)1L, (long)arrRead.size());
        Assert.assertEquals((long)5L, (long)arrRead.get(0));
    }

    @org.junit.Test
    public void testCopyConstructor() {
        ArrayListOfLongsWritable a = new ArrayListOfLongsWritable();
        a.add(1L).add(3L).add(5L);
        ArrayListOfLongsWritable b = new ArrayListOfLongsWritable(a);
        a.remove(0);
        Assert.assertEquals((long)1L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)5L, (long)b.get(2));
    }

    @org.junit.Test
    public void testCompare() {
        ArrayListOfLongsWritable a = new ArrayListOfLongsWritable();
        a.add(this.one).add(this.three).add(this.five);
        ArrayListOfLongsWritable b = new ArrayListOfLongsWritable();
        b.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        b.remove(3);
        Assert.assertTrue((b.compareTo(a) == 0 ? 1 : 0) != 0);
        b.remove(2);
        Assert.assertTrue((b.compareTo(a) < 0 ? 1 : 0) != 0);
        ArrayListOfLongsWritable c = new ArrayListOfLongsWritable();
        Assert.assertTrue((b.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testCompare2() {
        ArrayListOfLongsWritable a = new ArrayListOfLongsWritable();
        a.add(this.one).add(this.three).add(this.six);
        ArrayListOfLongsWritable b = new ArrayListOfLongsWritable();
        b.add(this.one).add(this.three).add(this.four);
        Assert.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        ArrayListOfLongsWritable c = new ArrayListOfLongsWritable();
        c.add(this.one).add(this.three).add(this.four).add(this.nine);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
        ArrayListOfLongsWritable d = new ArrayListOfLongsWritable();
        d.add(this.two).add(this.four);
        ArrayListOfLongsWritable e = new ArrayListOfLongsWritable();
        e.add(this.zero).add(this.two);
        Assert.assertTrue((d.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(d) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfLongsWritableTest.class);
    }
}

