/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.WritableComparable;

public class ArrayListWritableComparable<E extends WritableComparable>
extends ArrayList<E>
implements WritableComparable<ArrayListWritableComparable<E>> {
    private static final long serialVersionUID = 1L;

    public ArrayListWritableComparable() {
    }

    public ArrayListWritableComparable(ArrayList<E> array) {
        super(array);
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numFields = in.readInt();
        if (numFields == 0) {
            return;
        }
        String className = in.readUTF();
        try {
            Class<?> c = Class.forName(className);
            for (int i = 0; i < numFields; ++i) {
                WritableComparable obj = (WritableComparable)c.newInstance();
                obj.readFields(in);
                this.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        WritableComparable obj = (WritableComparable)this.get(0);
        out.writeUTF(obj.getClass().getCanonicalName());
        for (int i = 0; i < this.size(); ++i) {
            obj = (WritableComparable)this.get(i);
            if (obj == null) {
                throw new IOException("Cannot serialize null fields!");
            }
            obj.write(out);
        }
    }

    public int compareTo(ArrayListWritableComparable<E> obj) {
        ArrayListWritableComparable<E> that = obj;
        for (int i = 0; i < this.size(); ++i) {
            Comparable thatField;
            if (i >= that.size()) {
                return 1;
            }
            Comparable thisField = (Comparable)this.get(i);
            if (thisField.equals(thatField = (Comparable)that.get(i))) {
                if (i != this.size() - 1) continue;
                if (this.size() > that.size()) {
                    return 1;
                }
                if (this.size() >= that.size()) continue;
                return -1;
            }
            return thisField.compareTo((WritableComparable)thatField);
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

