/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import edu.umd.cloud9.io.array.ArrayListWritableComparable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class ArrayListWritableComparableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        ArrayListWritableComparable<Text> list = new ArrayListWritableComparable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        Assert.assertEquals((Object)((Text)list.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)list.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        ArrayListWritableComparable<Text> list = new ArrayListWritableComparable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritableComparable newList = new ArrayListWritableComparable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)((Text)newList.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)newList.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        ArrayListWritableComparable<FloatWritable> list = new ArrayListWritableComparable<FloatWritable>();
        list.add(new FloatWritable(0.3f));
        list.add(new FloatWritable(3244.2f));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritableComparable newList = new ArrayListWritableComparable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((((FloatWritable)newList.get(0)).get() == 0.3f ? 1 : 0) != 0);
        Assert.assertTrue((((FloatWritable)newList.get(1)).get() == 3244.2f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testToString() {
        ArrayListWritableComparable<Text> list = new ArrayListWritableComparable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        Assert.assertEquals((Object)list.toString(), (Object)"[hi, there]");
    }

    @org.junit.Test
    public void testClear() {
        ArrayListWritableComparable<Text> list = new ArrayListWritableComparable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        list.clear();
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @org.junit.Test
    public void testEmpty() throws IOException {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritableComparable<Text> newList = new ArrayListWritableComparable<Text>();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
        newList.add(new Text("Hey"));
        Assert.assertEquals(newList.get(0), (Object)new Text("Hey"));
    }

    @org.junit.Test
    public void testListMethods() {
        IntWritable a = new IntWritable(1);
        IntWritable b = new IntWritable(2);
        IntWritable c = new IntWritable(3);
        IntWritable d = new IntWritable(4);
        IntWritable e = new IntWritable(5);
        ArrayListWritableComparable<IntWritable> list = new ArrayListWritableComparable<IntWritable>();
        Assert.assertTrue((boolean)list.isEmpty());
        list.add(a);
        list.add(b);
        list.add(c);
        list.add(d);
        list.add(e);
        int pos = 0;
        for (IntWritable i : list) {
            Assert.assertEquals((Object)i, list.get(pos));
            ++pos;
        }
        Assert.assertTrue((list.indexOf(d) == 3 ? 1 : 0) != 0);
        list.add(2, a);
        Assert.assertTrue((list.lastIndexOf(a) == 2 ? 1 : 0) != 0);
        Assert.assertEquals(list.get(2), list.get(0));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains(c));
        Assert.assertTrue((!list.contains(new IntWritable(123)) ? 1 : 0) != 0);
        ArrayList<IntWritable> otherList = new ArrayList<IntWritable>();
        otherList.add(a);
        otherList.add(b);
        otherList.add(c);
        Assert.assertTrue((boolean)list.containsAll(otherList));
        otherList.add(new IntWritable(200));
        Assert.assertTrue((!list.containsAll(otherList) ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, otherList.remove(0));
        Assert.assertTrue((boolean)list.remove(d));
    }

    @org.junit.Test
    public void testSorting1() {
        ArrayListWritableComparable<Object> list1 = new ArrayListWritableComparable<Object>();
        ArrayListWritableComparable list2 = new ArrayListWritableComparable();
        list1.add(new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) > 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSorting2() {
        ArrayListWritableComparable<Object> list1 = new ArrayListWritableComparable<Object>();
        ArrayListWritableComparable<Object> list2 = new ArrayListWritableComparable<Object>();
        list1.add(new Text("a"));
        list2.add(new Text("b"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        list2.clear();
        list2.add(new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) == 0 ? 1 : 0) != 0);
        list1.add(new Text("a"));
        list2.add(new Text("b"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        list1.add(new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSorting3() {
        ArrayListWritableComparable<Object> list1 = new ArrayListWritableComparable<Object>();
        ArrayListWritableComparable<Object> list2 = new ArrayListWritableComparable<Object>();
        ArrayListWritableComparable<Object> list3 = new ArrayListWritableComparable<Object>();
        list1.add(new Text("a"));
        list2.add(new Text("a"));
        list2.add(new Text("a"));
        list3.add(new Text("a"));
        list3.add(new Text("a"));
        Assert.assertTrue((list2.compareTo(list3) == 0 ? 1 : 0) != 0);
        list3.add(new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list1.compareTo(list3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list3.compareTo(list1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((list3.compareTo(list2) > 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListWritableComparableTest.class);
    }
}

