/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import edu.umd.cloud9.io.array.ArrayListWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;

public class ArrayListWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        ArrayListWritable<Text> list = new ArrayListWritable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        Assert.assertEquals((Object)((Text)list.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)list.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        ArrayListWritable<Text> list = new ArrayListWritable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)((Text)newList.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)newList.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        ArrayListWritable<FloatWritable> list = new ArrayListWritable<FloatWritable>();
        list.add(new FloatWritable(0.3f));
        list.add(new FloatWritable(3244.2f));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((((FloatWritable)newList.get(0)).get() == 0.3f ? 1 : 0) != 0);
        Assert.assertTrue((((FloatWritable)newList.get(1)).get() == 3244.2f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        ArrayListWritable<Object> list = new ArrayListWritable<Object>();
        list.add(new Text("hi"));
        list.add(new IntWritable(1));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        try {
            Assert.assertEquals((Object)((Writable)newList.get(0)).toString(), (Object)"hi");
            IntWritable i = (IntWritable)newList.get(1);
            Assert.assertEquals((long)i.get(), (long)1L);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testToString() {
        ArrayListWritable<Text> list = new ArrayListWritable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        Assert.assertEquals((Object)list.toString(), (Object)"[hi, there]");
    }

    @org.junit.Test
    public void testClear() {
        ArrayListWritable<Text> list = new ArrayListWritable<Text>();
        list.add(new Text("hi"));
        list.add(new Text("there"));
        list.clear();
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @org.junit.Test
    public void testEmpty() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write(dataOut);
        ArrayListWritable<Text> newList = new ArrayListWritable<Text>();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
        newList.add(new Text("Hey"));
        Assert.assertEquals(newList.get(0), (Object)new Text("Hey"));
    }

    @org.junit.Test
    public void testListMethods() {
        IntWritable a = new IntWritable(1);
        IntWritable b = new IntWritable(2);
        IntWritable c = new IntWritable(3);
        IntWritable d = new IntWritable(4);
        IntWritable e = new IntWritable(5);
        ArrayListWritable<IntWritable> list = new ArrayListWritable<IntWritable>();
        Assert.assertTrue((boolean)list.isEmpty());
        list.add(a);
        list.add(b);
        list.add(c);
        list.add(d);
        list.add(e);
        int pos = 0;
        for (IntWritable i : list) {
            Assert.assertEquals((Object)i, list.get(pos));
            ++pos;
        }
        Assert.assertTrue((list.indexOf(d) == 3 ? 1 : 0) != 0);
        list.add(2, a);
        Assert.assertTrue((list.lastIndexOf(a) == 2 ? 1 : 0) != 0);
        Assert.assertEquals(list.get(2), list.get(0));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains(c));
        Assert.assertTrue((!list.contains(new IntWritable(123)) ? 1 : 0) != 0);
        ArrayList<IntWritable> otherList = new ArrayList<IntWritable>();
        otherList.add(a);
        otherList.add(b);
        otherList.add(c);
        Assert.assertTrue((boolean)list.containsAll(otherList));
        otherList.add(new IntWritable(200));
        Assert.assertTrue((!list.containsAll(otherList) ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, otherList.remove(0));
        Assert.assertTrue((boolean)list.remove(d));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListWritableTest.class);
    }
}

