/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ArrayOfDoublesWritable
implements Writable {
    double[] array;

    public ArrayOfDoublesWritable() {
    }

    public ArrayOfDoublesWritable(double[] array) {
        this.array = array;
    }

    public ArrayOfDoublesWritable(int size) {
        this.array = new double[size];
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.array = new double[size];
        for (int i = 0; i < size; ++i) {
            this.set(i, in.readDouble());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            out.writeDouble(this.get(i));
        }
    }

    public double[] getClone() {
        return (double[])this.array.clone();
    }

    public double[] getArray() {
        return this.array;
    }

    public void setArray(double[] array) {
        this.array = array;
    }

    public double get(int i) {
        return this.array[i];
    }

    public void set(int i, double f) {
        this.array[i] = f;
    }

    public int size() {
        return this.array.length;
    }

    public String toString() {
        String s = "[";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.get(i) + ",";
        }
        s = s + "]";
        return s;
    }
}

