/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ArrayOfFloatsWritable
implements Writable {
    float[] array;

    public ArrayOfFloatsWritable() {
    }

    public ArrayOfFloatsWritable(float[] array) {
        this.array = array;
    }

    public ArrayOfFloatsWritable(int size) {
        this.array = new float[size];
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.array = new float[size];
        for (int i = 0; i < size; ++i) {
            this.set(i, in.readFloat());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            out.writeFloat(this.get(i));
        }
    }

    public float[] getClone() {
        return (float[])this.array.clone();
    }

    public float[] getArray() {
        return this.array;
    }

    public void setArray(float[] array) {
        this.array = array;
    }

    public float get(int i) {
        return this.array[i];
    }

    public void set(int i, float f) {
        this.array[i] = f;
    }

    public int size() {
        return this.array.length;
    }

    public String toString() {
        String s = "[";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.get(i) + ",";
        }
        s = s + "]";
        return s;
    }
}

