/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.benchmark;

import edu.umd.cloud9.io.map.HashMapWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Random;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;

public class BenchmarkHashMapWritable {
    private BenchmarkHashMapWritable() {
    }

    public static void main(String[] args) throws Exception {
        MapWritable map;
        int i;
        long startTime = System.currentTimeMillis();
        int numTrials = 100000;
        Random rand = new Random();
        ByteArrayOutputStream[] storageHashMapWritable = new ByteArrayOutputStream[numTrials];
        for (int i2 = 0; i2 < numTrials; ++i2) {
            HashMapWritable<IntWritable, IntWritable> map2 = new HashMapWritable<IntWritable, IntWritable>();
            int size = rand.nextInt(50) + 50;
            for (int j = 0; j < size; ++j) {
                map2.put(new IntWritable(rand.nextInt(10000)), new IntWritable(rand.nextInt(10)));
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            map2.write(dataOut);
            storageHashMapWritable[i2] = bytesOut;
        }
        System.out.println("Generating and serializing " + numTrials + " random HashMapWritables: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        startTime = System.currentTimeMillis();
        ByteArrayOutputStream[] storageMapWritable = new ByteArrayOutputStream[numTrials];
        for (int i3 = 0; i3 < numTrials; ++i3) {
            MapWritable map3 = new MapWritable();
            int size = rand.nextInt(50) + 50;
            for (int j = 0; j < size; ++j) {
                map3.put((Writable)new IntWritable(rand.nextInt(10000)), (Writable)new IntWritable(rand.nextInt(10)));
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            map3.write((DataOutput)dataOut);
            storageMapWritable[i3] = bytesOut;
        }
        System.out.println("Generating and serializing " + numTrials + " random MapWritables: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        float cntA = 0.0f;
        float cntB = 0.0f;
        for (i = 0; i < numTrials; ++i) {
            cntA += (float)storageHashMapWritable[i].size();
            cntB += (float)storageMapWritable[i].size();
        }
        System.out.println("Average size of each HashMapWritable: " + cntA / (float)numTrials);
        System.out.println("Average size of each MapWritable: " + cntB / (float)numTrials);
        startTime = System.currentTimeMillis();
        for (i = 0; i < numTrials; ++i) {
            map = new HashMapWritable();
            map.readFields(new DataInputStream(new ByteArrayInputStream(storageHashMapWritable[i].toByteArray())));
        }
        System.out.println("Deserializing " + numTrials + " random MapWritables: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        startTime = System.currentTimeMillis();
        for (i = 0; i < numTrials; ++i) {
            map = new MapWritable();
            map.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(storageMapWritable[i].toByteArray())));
        }
        System.out.println("Deserializing " + numTrials + " random MapWritables: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
    }
}

