/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.benchmark;

import edu.umd.cloud9.io.JsonWritable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.hadoop.io.WritableComparable;

public class BenchmarkJson {
    private static final int SAMPLES = 1000000;

    private BenchmarkJson() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Number of samples: 1000000");
        Random r = new Random();
        long startTime = System.currentTimeMillis();
        ArrayList<MyJsonWritable> listJSONObjects1 = new ArrayList<MyJsonWritable>();
        for (int i = 0; i < 1000000; ++i) {
            MyJsonWritable j = new MyJsonWritable();
            j.getJsonObject().addProperty("left", (Number)r.nextInt(1000));
            j.getJsonObject().addProperty("right", (Number)r.nextInt(1000));
            listJSONObjects1.add(j);
        }
        double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Generated JSON Objects in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        ArrayList<MyJsonWritable> listJSONObjects2 = new ArrayList<MyJsonWritable>();
        for (MyJsonWritable t : listJSONObjects1) {
            MyJsonWritable n = new MyJsonWritable();
            n.getJsonObject().addProperty("left", (Number)t.getJsonObject().get("left").getAsInt());
            n.getJsonObject().addProperty("right", (Number)t.getJsonObject().get("right").getAsInt());
            listJSONObjects2.add(n);
        }
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Cloned 1000000 JSON Objects in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        Collections.sort(listJSONObjects2);
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Sorted JSON Objects in " + duration + " seconds");
    }

    private static class MyJsonWritable
    extends JsonWritable
    implements WritableComparable<MyJsonWritable> {
        private MyJsonWritable() {
        }

        public int compareTo(MyJsonWritable that) {
            int thisLeft = this.getJsonObject().get("left").getAsInt();
            int thisRight = this.getJsonObject().get("right").getAsInt();
            int thatLeft = that.getJsonObject().get("left").getAsInt();
            int thatRight = that.getJsonObject().get("right").getAsInt();
            if (thisLeft == thatLeft) {
                if (thisRight < thatRight) {
                    return -1;
                }
                if (thisRight > thatRight) {
                    return 1;
                }
                return 0;
            }
            if (thisLeft < thatLeft) {
                return -1;
            }
            if (thisLeft > thatLeft) {
                return 1;
            }
            return 0;
        }
    }
}

