/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.benchmark;

import edu.umd.cloud9.io.pair.PairOfInts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class BenchmarkPairOfInts {
    private static final int SAMPLES = 1000000;

    private BenchmarkPairOfInts() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Number of samples: 1000000");
        Random r = new Random();
        long startTime = System.currentTimeMillis();
        ArrayList<PairOfInts> listPairOfInts1 = new ArrayList<PairOfInts>();
        for (int i = 0; i < 1000000; ++i) {
            listPairOfInts1.add(new PairOfInts(r.nextInt(1000), r.nextInt(1000)));
        }
        double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Generated PairOfInts in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        ArrayList<PairOfInts> listPairOfInts2 = new ArrayList<PairOfInts>();
        for (PairOfInts p : listPairOfInts1) {
            listPairOfInts2.add(p.clone());
        }
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Cloned PairOfInts in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        Collections.sort(listPairOfInts2);
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Sorted PairOfInts in " + duration + " seconds");
    }
}

