/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.benchmark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class BenchmarkTuple {
    private static final int SAMPLES = 1000000;
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    private BenchmarkTuple() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Number of samples: 1000000");
        Random r = new Random();
        long startTime = System.currentTimeMillis();
        ArrayList<Tuple> listTuples1 = new ArrayList<Tuple>();
        for (int i = 0; i < 1000000; ++i) {
            Tuple tuple = TUPLE_FACTORY.newTuple();
            tuple.append((Object)r.nextInt(1000));
            tuple.append((Object)r.nextInt(1000));
            listTuples1.add(tuple);
        }
        double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Generated Tuples in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        ArrayList<Tuple> listTuples2 = new ArrayList<Tuple>();
        for (Tuple t : listTuples1) {
            Tuple n = TUPLE_FACTORY.newTuple();
            n.append(t.get(0));
            n.append(t.get(1));
            listTuples2.add(n);
        }
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Cloned Tuples in " + duration + " seconds");
        startTime = System.currentTimeMillis();
        Collections.sort(listTuples2, new Comparator<Tuple>(){

            @Override
            public int compare(Tuple thisOne, Tuple thatOne) {
                try {
                    int thisLeft = (Integer)thisOne.get(0);
                    int thisRight = (Integer)thisOne.get(1);
                    int thatLeft = (Integer)thatOne.get(0);
                    int thatRight = (Integer)thatOne.get(1);
                    if (thisLeft == thatLeft) {
                        if (thisRight < thatRight) {
                            return -1;
                        }
                        if (thisRight > thatRight) {
                            return 1;
                        }
                        return 0;
                    }
                    if (thisLeft < thatLeft) {
                        return -1;
                    }
                    if (thisLeft > thatLeft) {
                        return 1;
                    }
                    return 0;
                }
                catch (ExecException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Sorted Tuples in " + duration + " seconds");
    }
}

