/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.benchmark;

import edu.umd.cloud9.io.pair.PairOfInts;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class HadoopSortRandomPairsOfInts {
    private HadoopSortRandomPairsOfInts() {
    }

    public static void main(String[] args) throws IOException {
        String inputPath = "random-pairs.seq";
        String outputPath = "random-pairs.sorted";
        int numMapTasks = 1;
        int numReduceTasks = 1;
        JobConf conf = new JobConf(HadoopSortRandomPairsOfInts.class);
        conf.setJobName("SortRandomPairsOfInts");
        conf.setNumMapTasks(numMapTasks);
        conf.setNumReduceTasks(numReduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(PairOfInts.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setCombinerClass(IdentityReducer.class);
        conf.setReducerClass(IdentityReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        JobClient.runJob((JobConf)conf);
        double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Job took " + duration + " seconds");
    }
}

