/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.fastutil;

import edu.umd.cloud9.io.map.Int2FloatOpenHashMapWritable;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Int2FloatOpenHashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.put(2, 5.0f);
        m.put(1, 22.0f);
        Assert.assertEquals((long)2L, (long)m.size());
        float value = m.get(2);
        Assert.assertEquals((double)5.0, (double)value, (double)1.0E-5);
        value = m.remove(2);
        Assert.assertEquals((long)1L, (long)m.size());
        value = m.get(1);
        Assert.assertEquals((double)22.0, (double)value, (double)1.0E-5);
    }

    @org.junit.Test
    public void testIncrement() throws IOException {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.put(2, 7.0f);
        m.put(1, 29.0f);
        Assert.assertEquals((double)7.0, (double)m.get(2), (double)1.0E-5);
        Assert.assertEquals((double)29.0, (double)m.get(1), (double)1.0E-5);
        m.increment(2);
        m.increment(1);
        m.increment(3);
        Assert.assertEquals((double)8.0, (double)m.get(2), (double)1.0E-5);
        Assert.assertEquals((double)30.0, (double)m.get(1), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)m.get(3), (double)1.0E-5);
        m.increment(1, 3.0f);
        m.increment(3, 5.0f);
        Assert.assertEquals((double)8.0, (double)m.get(2), (double)1.0E-5);
        Assert.assertEquals((double)33.0, (double)m.get(1), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)m.get(3), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        Int2FloatOpenHashMapWritable.setLazyDecodeFlag(false);
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        Int2FloatOpenHashMapWritable n2 = Int2FloatOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)2L, (long)n2.size());
        float value = n2.get(3);
        Assert.assertEquals((double)5.0, (double)value, (double)1.0E-5);
        value = n2.remove(3);
        Assert.assertEquals((long)1L, (long)n2.size());
        value = n2.get(4);
        Assert.assertEquals((double)22.0, (double)value, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        Int2FloatOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        Int2FloatOpenHashMapWritable m2 = Int2FloatOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)0L, (long)m2.size());
        Assert.assertFalse((boolean)m2.hasBeenDecoded());
        int[] keys = m2.getKeys();
        float[] values = m2.getValues();
        Assert.assertEquals((long)3L, (long)keys[0]);
        Assert.assertEquals((long)4L, (long)keys[1]);
        Assert.assertEquals((double)5.0, (double)values[0], (double)1.0E-5);
        Assert.assertEquals((double)22.0, (double)values[1], (double)1.0E-5);
        m2.decode();
        Assert.assertTrue((boolean)m2.hasBeenDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        float value = m2.get(3);
        Assert.assertEquals((double)5.0, (double)value, (double)1.0E-5);
        value = m2.remove(3);
        Assert.assertEquals((long)1L, (long)m2.size());
        value = m2.get(4);
        Assert.assertEquals((double)22.0, (double)value, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerializeLazy2() throws IOException {
        Int2FloatOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        Int2FloatOpenHashMapWritable m2 = Int2FloatOpenHashMapWritable.create(m1.serialize());
        Int2FloatOpenHashMapWritable m3 = Int2FloatOpenHashMapWritable.create(m2.serialize());
        Assert.assertEquals((long)0L, (long)m3.size());
        Assert.assertFalse((boolean)m3.hasBeenDecoded());
        int[] keys = m3.getKeys();
        float[] values = m3.getValues();
        Assert.assertEquals((long)3L, (long)keys[0]);
        Assert.assertEquals((long)4L, (long)keys[1]);
        Assert.assertEquals((double)5.0, (double)values[0], (double)1.0E-5);
        Assert.assertEquals((double)22.0, (double)values[1], (double)1.0E-5);
        m3.decode();
        Assert.assertTrue((boolean)m3.hasBeenDecoded());
        Assert.assertEquals((long)2L, (long)m3.size());
        float value = m3.get(3);
        Assert.assertEquals((double)5.0, (double)value, (double)1.0E-5);
        value = m3.remove(3);
        Assert.assertEquals((long)1L, (long)m3.size());
        value = m3.get(4);
        Assert.assertEquals((double)22.0, (double)value, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.decode();
        Assert.assertEquals((long)0L, (long)m1.size());
        Int2FloatOpenHashMapWritable m2 = Int2FloatOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)0L, (long)m2.size());
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        Int2FloatOpenHashMapWritable map = new Int2FloatOpenHashMapWritable();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat() * (float)size;
            map.put(i, k);
            floats[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)floats[i], (double)map.get(i), (double)1.0E-5);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        Int2FloatOpenHashMapWritable map = new Int2FloatOpenHashMapWritable();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat() * (float)size;
            map.put(i, k);
            floats[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, floats[i] + 1.0f);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)(floats[i] + 1.0f), (double)map.get(i), (double)1.0E-5);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(1, 5.0f);
        m1.put(2, 22.0f);
        Int2FloatOpenHashMapWritable m2 = new Int2FloatOpenHashMapWritable();
        m2.put(1, 4.0f);
        m2.put(3, 5.0f);
        m1.plus(m2);
        Assert.assertEquals((double)3.0, (double)m1.size(), (double)3.0);
        Assert.assertEquals((double)9.0, (double)m1.get(1), (double)1.0E-5);
        Assert.assertEquals((double)22.0, (double)m1.get(2), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)m1.get(3), (double)1.0E-5);
    }

    @org.junit.Test
    public void testLazyPlus() throws IOException {
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(1, 5.0f);
        m1.put(2, 22.0f);
        Int2FloatOpenHashMapWritable m2 = new Int2FloatOpenHashMapWritable();
        m2.put(1, 4.0f);
        m2.put(3, 5.0f);
        Int2FloatOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2FloatOpenHashMapWritable m3 = Int2FloatOpenHashMapWritable.create(m2.serialize());
        Assert.assertEquals((long)0L, (long)m3.size());
        m1.lazyplus(m3);
        Assert.assertEquals((double)3.0, (double)m1.size(), (double)3.0);
        Assert.assertEquals((double)9.0, (double)m1.get(1), (double)1.0E-5);
        Assert.assertEquals((double)22.0, (double)m1.get(2), (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)m1.get(3), (double)1.0E-5);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        Int2FloatOpenHashMapWritable m1 = new Int2FloatOpenHashMapWritable();
        m1.put(1, 2.0f);
        m1.put(2, 1.0f);
        m1.put(3, 3.0f);
        Int2FloatOpenHashMapWritable m2 = new Int2FloatOpenHashMapWritable();
        m2.put(1, 1.0f);
        m2.put(2, 4.0f);
        m2.put(4, 5.0f);
        float s = m1.dot(m2);
        Assert.assertEquals((double)6.0, (double)s, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.put(1, 5.0f);
        m.put(2, 2.0f);
        m.put(3, 3.0f);
        m.put(4, 3.0f);
        m.put(5, 1.0f);
        Int2FloatMap.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((double)5.0, (double)e[0].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)e[1].getIntKey());
        Assert.assertEquals((double)3.0, (double)e[1].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)4L, (long)e[2].getIntKey());
        Assert.assertEquals((double)3.0, (double)e[2].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)e[3].getIntKey());
        Assert.assertEquals((double)2.0, (double)e[3].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)e[4].getIntKey());
        Assert.assertEquals((double)1.0, (double)e[4].getFloatValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries2() {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.put(1, 5.0f);
        m.put(2, 2.0f);
        m.put(3, 3.0f);
        m.put(4, 3.0f);
        m.put(5, 1.0f);
        Int2FloatMap.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((double)5.0, (double)e[0].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)e[1].getIntKey());
        Assert.assertEquals((double)3.0, (double)e[1].getFloatValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries3() {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        m.put(1, 5.0f);
        m.put(2, 2.0f);
        Int2FloatMap.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((double)5.0, (double)e[0].getFloatValue(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)e[1].getIntKey());
        Assert.assertEquals((double)2.0, (double)e[1].getFloatValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries4() {
        Int2FloatOpenHashMapWritable m = new Int2FloatOpenHashMapWritable();
        Int2FloatMap.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Int2FloatOpenHashMapWritableTest.class);
    }
}

