/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.fastutil;

import edu.umd.cloud9.io.map.Int2IntOpenHashMapWritable;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Int2IntOpenHashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.put(2, 5);
        m.put(1, 22);
        Assert.assertEquals((long)2L, (long)m.size());
        int value = m.get(2);
        Assert.assertEquals((long)5L, (long)value);
        value = m.remove(2);
        Assert.assertEquals((long)1L, (long)m.size());
        value = m.get(1);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testIncrement() throws IOException {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.put(2, 7);
        m.put(1, 29);
        Assert.assertEquals((long)7L, (long)m.get(2));
        Assert.assertEquals((long)29L, (long)m.get(1));
        m.increment(2);
        m.increment(1);
        m.increment(3);
        Assert.assertEquals((long)8L, (long)m.get(2));
        Assert.assertEquals((long)30L, (long)m.get(1));
        Assert.assertEquals((long)1L, (long)m.get(3));
        m.increment(1, 3);
        m.increment(3, 5);
        Assert.assertEquals((long)8L, (long)m.get(2));
        Assert.assertEquals((long)33L, (long)m.get(1));
        Assert.assertEquals((long)6L, (long)m.get(3));
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        Int2IntOpenHashMapWritable.setLazyDecodeFlag(false);
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(3, 5);
        m1.put(4, 22);
        Int2IntOpenHashMapWritable n2 = Int2IntOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)2L, (long)n2.size());
        int value = n2.get(3);
        Assert.assertEquals((long)5L, (long)value);
        value = n2.remove(3);
        Assert.assertEquals((long)1L, (long)n2.size());
        value = n2.get(4);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        Int2IntOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(3, 5);
        m1.put(4, 22);
        Int2IntOpenHashMapWritable m2 = Int2IntOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)0L, (long)m2.size());
        Assert.assertFalse((boolean)m2.hasBeenDecoded());
        int[] keys = m2.getKeys();
        int[] values = m2.getValues();
        Assert.assertEquals((long)3L, (long)keys[0]);
        Assert.assertEquals((long)4L, (long)keys[1]);
        Assert.assertEquals((long)5L, (long)values[0]);
        Assert.assertEquals((long)22L, (long)values[1]);
        m2.decode();
        Assert.assertTrue((boolean)m2.hasBeenDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        int value = m2.get(3);
        Assert.assertEquals((long)5L, (long)value);
        value = m2.remove(3);
        Assert.assertEquals((long)1L, (long)m2.size());
        value = m2.get(4);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testSerializeLazy2() throws IOException {
        Int2IntOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(3, 5);
        m1.put(4, 22);
        Int2IntOpenHashMapWritable m2 = Int2IntOpenHashMapWritable.create(m1.serialize());
        Int2IntOpenHashMapWritable m3 = Int2IntOpenHashMapWritable.create(m2.serialize());
        Assert.assertEquals((long)0L, (long)m3.size());
        Assert.assertFalse((boolean)m3.hasBeenDecoded());
        int[] keys = m3.getKeys();
        int[] values = m3.getValues();
        Assert.assertEquals((long)3L, (long)keys[0]);
        Assert.assertEquals((long)4L, (long)keys[1]);
        Assert.assertEquals((long)5L, (long)values[0]);
        Assert.assertEquals((long)22L, (long)values[1]);
        m3.decode();
        Assert.assertTrue((boolean)m3.hasBeenDecoded());
        Assert.assertEquals((long)2L, (long)m3.size());
        int value = m3.get(3);
        Assert.assertEquals((long)5L, (long)value);
        value = m3.remove(3);
        Assert.assertEquals((long)1L, (long)m3.size());
        value = m3.get(4);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.decode();
        Assert.assertEquals((long)0L, (long)m1.size());
        Int2IntOpenHashMapWritable m2 = Int2IntOpenHashMapWritable.create(m1.serialize());
        Assert.assertEquals((long)0L, (long)m2.size());
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        Int2IntOpenHashMapWritable map = new Int2IntOpenHashMapWritable();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)ints[i], (long)map.get(i));
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        Int2IntOpenHashMapWritable map = new Int2IntOpenHashMapWritable();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)(ints[i] + 1), (long)map.get(i));
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(1, 5);
        m1.put(2, 22);
        Int2IntOpenHashMapWritable m2 = new Int2IntOpenHashMapWritable();
        m2.put(1, 4);
        m2.put(3, 5);
        m1.plus(m2);
        Assert.assertEquals((long)3L, (long)m1.size());
        Assert.assertEquals((long)9L, (long)m1.get(1));
        Assert.assertEquals((long)22L, (long)m1.get(2));
        Assert.assertEquals((long)5L, (long)m1.get(3));
    }

    @org.junit.Test
    public void testLazyPlus() throws IOException {
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(1, 5);
        m1.put(2, 22);
        Int2IntOpenHashMapWritable m2 = new Int2IntOpenHashMapWritable();
        m2.put(1, 4);
        m2.put(3, 5);
        Int2IntOpenHashMapWritable.setLazyDecodeFlag(true);
        Int2IntOpenHashMapWritable m3 = Int2IntOpenHashMapWritable.create(m2.serialize());
        Assert.assertEquals((long)0L, (long)m3.size());
        m1.lazyplus(m3);
        Assert.assertEquals((long)3L, (long)m1.size());
        Assert.assertEquals((long)9L, (long)m1.get(1));
        Assert.assertEquals((long)22L, (long)m1.get(2));
        Assert.assertEquals((long)5L, (long)m1.get(3));
    }

    @org.junit.Test
    public void testDot() throws IOException {
        Int2IntOpenHashMapWritable m1 = new Int2IntOpenHashMapWritable();
        m1.put(1, 2);
        m1.put(2, 1);
        m1.put(3, 3);
        Int2IntOpenHashMapWritable m2 = new Int2IntOpenHashMapWritable();
        m2.put(1, 1);
        m2.put(2, 4);
        m2.put(4, 5);
        int s = m1.dot(m2);
        Assert.assertEquals((long)6L, (long)s);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.put(1, 5);
        m.put(2, 2);
        m.put(3, 3);
        m.put(4, 3);
        m.put(5, 1);
        Int2IntMap.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((long)5L, (long)e[0].getIntValue());
        Assert.assertEquals((long)3L, (long)e[1].getIntKey());
        Assert.assertEquals((long)3L, (long)e[1].getIntValue());
        Assert.assertEquals((long)4L, (long)e[2].getIntKey());
        Assert.assertEquals((long)3L, (long)e[2].getIntValue());
        Assert.assertEquals((long)2L, (long)e[3].getIntKey());
        Assert.assertEquals((long)2L, (long)e[3].getIntValue());
        Assert.assertEquals((long)5L, (long)e[4].getIntKey());
        Assert.assertEquals((long)1L, (long)e[4].getIntValue());
    }

    @org.junit.Test
    public void testSortedEntries2() {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.put(1, 5);
        m.put(2, 2);
        m.put(3, 3);
        m.put(4, 3);
        m.put(5, 1);
        Int2IntMap.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((long)5L, (long)e[0].getIntValue());
        Assert.assertEquals((long)3L, (long)e[1].getIntKey());
        Assert.assertEquals((long)3L, (long)e[1].getIntValue());
    }

    @org.junit.Test
    public void testSortedEntries3() {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        m.put(1, 5);
        m.put(2, 2);
        Int2IntMap.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getIntKey());
        Assert.assertEquals((long)5L, (long)e[0].getIntValue());
        Assert.assertEquals((long)2L, (long)e[1].getIntKey());
        Assert.assertEquals((long)2L, (long)e[1].getIntValue());
    }

    @org.junit.Test
    public void testSortedEntries4() {
        Int2IntOpenHashMapWritable m = new Int2IntOpenHashMapWritable();
        Int2IntMap.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(Int2IntOpenHashMapWritableTest.class);
    }
}

