/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.fastutil;

import com.google.common.collect.Lists;
import edu.umd.cloud9.io.map.String2FloatOpenHashMapWritable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class String2FloatOpenHashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        String2FloatOpenHashMapWritable m = new String2FloatOpenHashMapWritable();
        m.put("hi", 5.0f);
        m.put("there", 22.0f);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((double)5.0, (double)m.get("hi").floatValue(), (double)1.0E-5);
        m.remove("hi");
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((double)22.0, (double)m.get("there").floatValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testAccent() throws IOException {
        String2FloatOpenHashMapWritable map1 = new String2FloatOpenHashMapWritable();
        map1.put("\u00e0", 1.0f);
        map1.put("\u00e6", 2.0f);
        map1.put("\u00e7", 3.0f);
        map1.put("\u00fc", 4.0f);
        Assert.assertEquals((double)1.0, (double)map1.getFloat("\u00e0"), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map1.getFloat("\u00e6"), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)map1.getFloat("\u00e7"), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map1.getFloat("\u00fc"), (double)1.0E-5);
        map1.put("\u00e0", 10.0f);
        map1.remove("\u00e6");
        map1.remove("\u00e7");
        map1.put("\u00e7", 2.0f);
        Assert.assertEquals((double)10.0, (double)map1.getFloat("\u00e0"), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map1.getFloat("\u00e7"), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map1.getFloat("\u00fc"), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)map1.size());
        String2FloatOpenHashMapWritable map2 = String2FloatOpenHashMapWritable.create(map1.serialize());
        Assert.assertEquals((double)10.0, (double)map2.getFloat("\u00e0"), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map2.getFloat("\u00e7"), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map2.getFloat("\u00fc"), (double)1.0E-5);
    }

    @org.junit.Test
    public void testJp() throws IOException {
        int i;
        String line;
        String2FloatOpenHashMapWritable map1 = new String2FloatOpenHashMapWritable();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("etc/jp-sample.txt"), "UTF8"));
        ArrayList list = Lists.newArrayList();
        int cnt = 0;
        while ((line = in.readLine()) != null) {
            list.add(line);
            map1.put(line, cnt++);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((double)i2, (double)map1.get(list.get(i2)).floatValue(), (double)1.0E-5);
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        String2FloatOpenHashMapWritable map2 = String2FloatOpenHashMapWritable.create(map1.serialize());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((double)i, (double)map2.get(list.get(i)).floatValue(), (double)1.0E-5);
        }
        Assert.assertEquals((long)5L, (long)map2.size());
        for (i = 0; i < list.size(); ++i) {
            map2.remove(list.get(i));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
        in.close();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(String2FloatOpenHashMapWritableTest.class);
    }
}

