/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.fastutil;

import com.google.common.collect.Lists;
import edu.umd.cloud9.io.map.String2IntOpenHashMapWritable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class String2IntOpenHashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        String2IntOpenHashMapWritable m = new String2IntOpenHashMapWritable();
        m.put("hi", 5);
        m.put("there", 22);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((long)5L, (long)m.getInt("hi"));
        m.remove("hi");
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((long)22L, (long)m.getInt("there"));
    }

    @org.junit.Test
    public void testAccent() throws IOException {
        String2IntOpenHashMapWritable map1 = new String2IntOpenHashMapWritable();
        map1.put("\u00e0", 1);
        map1.put("\u00e6", 2);
        map1.put("\u00e7", 3);
        map1.put("\u00fc", 4);
        Assert.assertEquals((long)1L, (long)map1.getInt("\u00e0"));
        Assert.assertEquals((long)2L, (long)map1.getInt("\u00e6"));
        Assert.assertEquals((long)3L, (long)map1.getInt("\u00e7"));
        Assert.assertEquals((long)4L, (long)map1.getInt("\u00fc"));
        map1.increment("\u00e0");
        map1.increment("\u00e6");
        map1.increment("\u00e7");
        map1.increment("\u00fc");
        Assert.assertEquals((long)2L, (long)map1.getInt("\u00e0"));
        Assert.assertEquals((long)3L, (long)map1.getInt("\u00e6"));
        Assert.assertEquals((long)4L, (long)map1.getInt("\u00e7"));
        Assert.assertEquals((long)5L, (long)map1.getInt("\u00fc"));
        map1.put("\u00e0", 10);
        map1.remove("\u00e6");
        map1.remove("\u00e7");
        map1.put("\u00e7", 2);
        map1.increment("\u00fc");
        Assert.assertEquals((long)10L, (long)map1.getInt("\u00e0"));
        Assert.assertEquals((long)2L, (long)map1.getInt("\u00e7"));
        Assert.assertEquals((long)6L, (long)map1.getInt("\u00fc"));
        Assert.assertEquals((long)3L, (long)map1.size());
        String2IntOpenHashMapWritable map2 = String2IntOpenHashMapWritable.create(map1.serialize());
        Assert.assertEquals((long)10L, (long)map2.getInt("\u00e0"));
        Assert.assertEquals((long)2L, (long)map2.getInt("\u00e7"));
        Assert.assertEquals((long)6L, (long)map2.getInt("\u00fc"));
    }

    @org.junit.Test
    public void testJp() throws IOException {
        int i;
        int i2;
        String line;
        String2IntOpenHashMapWritable map1 = new String2IntOpenHashMapWritable();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("etc/jp-sample.txt"), "UTF8"));
        ArrayList list = Lists.newArrayList();
        int cnt = 0;
        while ((line = in.readLine()) != null) {
            list.add(line);
            map1.put(line, cnt++);
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((long)i2, (long)map1.getInt(list.get(i2)));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        for (i2 = 0; i2 < list.size(); ++i2) {
            map1.increment((String)list.get(i2));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        for (i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((long)(i2 + 1), (long)map1.getInt(list.get(i2)));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        String2IntOpenHashMapWritable map2 = String2IntOpenHashMapWritable.create(map1.serialize());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((long)(i + 1), (long)map2.getInt(list.get(i)));
        }
        Assert.assertEquals((long)5L, (long)map2.size());
        for (i = 0; i < list.size(); ++i) {
            map2.remove(list.get(i));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
        in.close();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(String2IntOpenHashMapWritableTest.class);
    }
}

