/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.io.map.HMapIDW;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class HMapIDWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIDW m = new HMapIDW();
        m.put(2, 5.0);
        m.put(1, 22.0);
        Assert.assertEquals((long)m.size(), (long)2L);
        double value = m.get(2);
        Assert.assertTrue((value == 5.0 ? 1 : 0) != 0);
        value = m.remove(2);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(1);
        Assert.assertTrue((value == 22.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapIDW.setLazyDecodeFlag(false);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes = m1.serialize();
        HMapIDW n2 = HMapIDW.create(bytes);
        Assert.assertEquals((long)n2.size(), (long)2L);
        double value = n2.get(3);
        Assert.assertTrue((value == 5.0 ? 1 : 0) != 0);
        value = n2.remove(3);
        Assert.assertEquals((long)n2.size(), (long)1L);
        value = n2.get(4);
        Assert.assertTrue((value == 22.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes = m1.serialize();
        HMapIDW m2 = HMapIDW.create(bytes);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        double[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 5.0 ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 22.0 ? 1 : 0) != 0);
        m2.decode();
        Assert.assertTrue((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        double value = m2.get(3);
        Assert.assertTrue((value == 5.0 ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)1L, (long)m2.size());
        value = m2.get(4);
        Assert.assertTrue((value == 22.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeLazy2() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes = m1.serialize();
        HMapIDW m2 = HMapIDW.create(bytes);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        double[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 5.0 ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 22.0 ? 1 : 0) != 0);
        m2.decode();
        Assert.assertEquals((long)m2.size(), (long)2L);
        double value = m2.get(3);
        Assert.assertTrue((value == 5.0 ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)m2.size(), (long)1L);
        value = m2.get(4);
        Assert.assertTrue((value == 22.0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testLazyPlus1() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes1 = m1.serialize();
        HMapIDW m2 = new HMapIDW();
        m2.put(3, 1.0);
        m2.put(4, 1.0);
        m2.put(5, 1.0);
        byte[] bytes2 = m2.serialize();
        HMapIDW n1 = HMapIDW.create(bytes1);
        HMapIDW n2 = HMapIDW.create(bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertFalse((boolean)n2.isDecoded());
    }

    @org.junit.Test
    public void testLazyPlus2() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes1 = m1.serialize();
        HMapIDW m2 = new HMapIDW();
        m2.put(3, 1.0);
        m2.put(4, 1.0);
        m2.put(5, 1.0);
        byte[] bytes2 = m2.serialize();
        HMapIDW n1 = HMapIDW.create(bytes1);
        HMapIDW n2 = HMapIDW.create(bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n2.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertTrue((boolean)n2.isDecoded());
    }

    @org.junit.Test
    public void testLazyPlus3() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes1 = m1.serialize();
        HMapIDW m2 = new HMapIDW();
        m2.put(3, 1.0);
        m2.put(4, 1.0);
        m2.put(5, 1.0);
        byte[] bytes2 = m2.serialize();
        HMapIDW n1 = HMapIDW.create(bytes1);
        HMapIDW n2 = HMapIDW.create(bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertFalse((boolean)n2.isDecoded());
    }

    @org.junit.Test
    public void testLazyPlus4() throws IOException {
        HMapIDW.setLazyDecodeFlag(true);
        HMapIDW m1 = new HMapIDW();
        m1.put(3, 5.0);
        m1.put(4, 22.0);
        byte[] bytes1 = m1.serialize();
        HMapIDW m2 = new HMapIDW();
        m2.put(3, 1.0);
        m2.put(4, 1.0);
        m2.put(5, 1.0);
        byte[] bytes2 = m2.serialize();
        HMapIDW n1 = HMapIDW.create(bytes1);
        HMapIDW n2 = HMapIDW.create(bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.decode();
        n2.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertTrue((boolean)n2.isDecoded());
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapIDW m1 = new HMapIDW();
        m1.decode();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        byte[] bytes = m1.serialize();
        HMapIDW m2 = HMapIDW.create(bytes);
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIDWTest.class);
    }
}

