/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.util.map.HMapII;
import edu.umd.cloud9.util.map.MapII;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class HMapIIW
extends HMapII
implements Writable {
    private static boolean LazyDecode = false;
    private static final long serialVersionUID = 3801790315L;
    private int numEntries = 0;
    private int[] keys = null;
    private int[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LazyDecode) {
            this.keys = new int[this.numEntries];
            this.values = new int[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readInt();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                this.put(in.readInt(), in.readInt());
            }
        }
    }

    public void decode() throws IOException {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
        this.values = null;
    }

    public boolean isDecoded() {
        if (!HMapIIW.getLazyDecodeFlag()) {
            return true;
        }
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (MapII.Entry e : this.entrySet()) {
            out.writeInt(e.getKey());
            out.writeInt(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static HMapIIW create(DataInput in) throws IOException {
        HMapIIW m = new HMapIIW();
        m.readFields(in);
        return m;
    }

    public static HMapIIW create(byte[] bytes) throws IOException {
        return HMapIIW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public static void setLazyDecodeFlag(boolean b) {
        LazyDecode = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LazyDecode;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    public void lazyplus(HMapIIW m) {
        int[] k = m.getKeys();
        int[] v = m.getValues();
        for (int i = 0; i < k.length; ++i) {
            if (this.containsKey(k[i])) {
                this.put(k[i], this.get(k[i]) + v[i]);
                continue;
            }
            this.put(k[i], v[i]);
        }
    }

    @Override
    public int size() {
        if (!this.isDecoded()) {
            return this.keys.length;
        }
        return super.size();
    }
}

