/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.util.map.HMapKF;
import edu.umd.cloud9.util.map.MapKF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HMapKFW<K extends WritableComparable<?>>
extends HMapKF<K>
implements Writable {
    private static final long serialVersionUID = 1343885977770942281L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String keyClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            for (int i = 0; i < numEntries; ++i) {
                WritableComparable objK = (WritableComparable)keyClass.newInstance();
                objK.readFields(in);
                float s = in.readFloat();
                this.put(objK, s);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to create HMapKFW!");
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Set entries = this.entrySet();
        MapKF.Entry first = entries.iterator().next();
        WritableComparable objK = (WritableComparable)first.getKey();
        out.writeUTF(objK.getClass().getCanonicalName());
        for (MapKF.Entry e : this.entrySet()) {
            ((WritableComparable)e.getKey()).write(out);
            out.writeFloat(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static <T extends WritableComparable<?>> HMapKFW<T> create(DataInput in) throws IOException {
        HMapKFW m = new HMapKFW();
        m.readFields(in);
        return m;
    }

    public static <T extends WritableComparable<?>> HMapKFW<T> create(byte[] bytes) throws IOException {
        return HMapKFW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

