/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.io.map.HMapKFW;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class HMapKFWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKFW<Text> m = new HMapKFW<Text>();
        m.put(new Text("hi"), 5.0f);
        m.put(new Text("there"), 22.0f);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        float value = m.get(key);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m.remove(key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get(key);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapKFW<Text> m1 = new HMapKFW<Text>();
        m1.put(new Text("hi"), 5.0f);
        m1.put(new Text("there"), 22.0f);
        HMapKFW n2 = HMapKFW.create(m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        Text key = new Text("hi");
        float value = n2.get(key);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = n2.remove(key);
        Assert.assertEquals((long)n2.size(), (long)1L);
        key = new Text("there");
        value = n2.get(key);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=IOException.class)
    public void testTypeSafety() throws IOException {
        HMapKFW<Object> m1 = new HMapKFW<Object>();
        m1.put((Object)new Text("hi"), 4.0f);
        m1.put((Object)new IntWritable(0), 76.0f);
        HMapKFW m2 = HMapKFW.create(m1.serialize());
        m2.size();
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapKFW m1 = new HMapKFW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapKFW m2 = HMapKFW.create(m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKFWTest.class);
    }
}

