/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.io.map.HMapKIW;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class HMapKIWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKIW<Text> m = new HMapKIW<Text>();
        m.put(new Text("hi"), 5);
        m.put(new Text("there"), 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        int value = m.get(key);
        Assert.assertEquals((long)value, (long)5L);
        value = m.remove(key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get(key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapKIW<Text> m1 = new HMapKIW<Text>();
        m1.put(new Text("hi"), 5);
        m1.put(new Text("there"), 22);
        HMapKIW m2 = HMapKIW.create(m1.serialize());
        Assert.assertEquals((long)m2.size(), (long)2L);
        Text key = new Text("hi");
        int value = m2.get(key);
        Assert.assertEquals((long)value, (long)5L);
        value = m2.remove(key);
        Assert.assertEquals((long)m2.size(), (long)1L);
        key = new Text("there");
        value = m2.get(key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test(expected=IOException.class)
    public void testTypeSafety() throws IOException {
        HMapKIW<Object> m1 = new HMapKIW<Object>();
        m1.put((Object)new Text("hi"), 4);
        m1.put((Object)new IntWritable(0), 76);
        HMapKIW m2 = HMapKIW.create(m1.serialize());
        m2.size();
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapKIW m1 = new HMapKIW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapKIW m2 = HMapKIW.create(m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKIWTest.class);
    }
}

