/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.Writable;

public class HashMapWritable<K extends Writable, V extends Writable>
extends HashMap<K, V>
implements Writable {
    private static final long serialVersionUID = -7549423384046548469L;

    public HashMapWritable() {
    }

    public HashMapWritable(HashMap<K, V> map) {
        super(map);
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String keyClassName = in.readUTF();
        String valueClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            Class<?> valueClass = Class.forName(valueClassName);
            for (int i = 0; i < numEntries; ++i) {
                Writable objK = (Writable)keyClass.newInstance();
                objK.readFields(in);
                Writable objV = (Writable)valueClass.newInstance();
                objV.readFields(in);
                this.put(objK, objV);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Set entries = this.entrySet();
        Map.Entry first = entries.iterator().next();
        Writable objK = (Writable)first.getKey();
        Writable objV = (Writable)first.getValue();
        out.writeUTF(objK.getClass().getCanonicalName());
        out.writeUTF(objV.getClass().getCanonicalName());
        for (Map.Entry e : this.entrySet()) {
            ((Writable)e.getKey()).write(out);
            ((Writable)e.getValue()).write(out);
        }
    }
}

