/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import edu.umd.cloud9.io.map.HashMapWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class HashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HashMapWritable<Text, IntWritable> map = new HashMapWritable<Text, IntWritable>();
        map.put(new Text("hi"), new IntWritable(5));
        map.put(new Text("there"), new IntWritable(22));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        IntWritable value = (IntWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)5L);
        value = (IntWritable)map.remove(key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (IntWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)22L);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HashMapWritable<Text, IntWritable> origMap = new HashMapWritable<Text, IntWritable>();
        origMap.put(new Text("hi"), new IntWritable(5));
        origMap.put(new Text("there"), new IntWritable(22));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write(dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        IntWritable value = (IntWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)5L);
        value = (IntWritable)map.remove(key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (IntWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)22L);
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        HashMapWritable<Text, LongWritable> origMap = new HashMapWritable<Text, LongWritable>();
        origMap.put(new Text("hi"), new LongWritable(52L));
        origMap.put(new Text("there"), new LongWritable(77L));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write(dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        LongWritable value = (LongWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)52L);
        value = (LongWritable)map.remove(key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (LongWritable)map.get(key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)77L);
    }

    @org.junit.Test(expected=IOException.class)
    public void testTypeSafety() throws IOException {
        HashMapWritable<Text, Object> origMap = new HashMapWritable<Text, Object>();
        origMap.put(new Text("hi"), new FloatWritable(5.3f));
        origMap.put(new Text("there"), new Text("bbb"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write(dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HashMapWritable map = new HashMapWritable();
        Assert.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        map.write(dataOut);
        HashMapWritable newList = new HashMapWritable();
        newList.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HashMapWritableTest.class);
    }
}

