/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class JpEncodingTest {
    private void writeOutput(String str, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF8");
            out.write(str);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readInput(String file) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @org.junit.Test
    public void testJp() throws IOException {
        PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        String jpString = new String("\u65e5\u672c\u8a9e\u6587\u5b57\u5217");
        String file = "test.txt";
        this.writeOutput(jpString, file);
        String inputString = this.readInput(file);
        out.println(jpString + " " + inputString);
        Assert.assertEquals((Object)jpString, (Object)inputString);
        new File(file).delete();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(JpEncodingTest.class);
    }
}

