/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class Object2IntOpenHashMapWritable<K extends Writable>
extends Object2IntOpenHashMap<K>
implements Writable {
    private static final long serialVersionUID = 276091731841463L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String keyClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            for (int i = 0; i < numEntries; ++i) {
                Writable objK = (Writable)keyClass.newInstance();
                objK.readFields(in);
                int s = in.readInt();
                this.put(objK, s);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Object2IntMap.FastEntrySet entries = this.object2IntEntrySet();
        Object2IntMap.Entry first = (Object2IntMap.Entry)entries.iterator().next();
        Writable objK = (Writable)first.getKey();
        out.writeUTF(objK.getClass().getCanonicalName());
        for (Object2IntMap.Entry e : this.object2IntEntrySet()) {
            ((Writable)e.getKey()).write(out);
            out.writeInt((Integer)e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static <K extends Writable> Object2IntOpenHashMapWritable<K> create(DataInput in) throws IOException {
        Object2IntOpenHashMapWritable<K> m = new Object2IntOpenHashMapWritable<K>();
        m.readFields(in);
        return m;
    }

    public static <K extends Writable> Object2IntOpenHashMapWritable<K> create(byte[] bytes) throws IOException {
        return Object2IntOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(Object2IntOpenHashMapWritable<K> m) {
        for (Object2IntMap.Entry e : m.object2IntEntrySet()) {
            Writable key = (Writable)e.getKey();
            if (this.containsKey(key)) {
                this.put(key, this.get(key) + (Integer)e.getValue());
                continue;
            }
            this.put(key, (Integer)e.getValue());
        }
    }

    public int dot(Object2IntOpenHashMapWritable<K> m) {
        int s = 0;
        for (Object2IntMap.Entry e : m.object2IntEntrySet()) {
            Writable key = (Writable)e.getKey();
            if (!this.containsKey(key)) continue;
            s += this.get(key) * (Integer)e.getValue();
        }
        return s;
    }

    public void increment(K key) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + 1);
        } else {
            this.put(key, 1);
        }
    }
}

