/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfFloatInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfFloatIntTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfFloatInt pair = new PairOfFloatInt(3.14f, 2);
        Assert.assertTrue((pair.getLeftElement() == 3.14f ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfFloatInt origPair = new PairOfFloatInt(3.14f, 2);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfFloatInt pair = new PairOfFloatInt();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((pair.getLeftElement() == 3.14f ? 1 : 0) != 0);
        Assert.assertEquals((long)pair.getRightElement(), (long)2L);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfFloatInt pair1 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair2 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair3 = new PairOfFloatInt(3.14f, 1);
        PairOfFloatInt pair4 = new PairOfFloatInt(0.3f, 9);
        PairOfFloatInt pair5 = new PairOfFloatInt(9.9f, 0);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfFloatInt.Comparator comparator = new PairOfFloatInt.Comparator();
        PairOfFloatInt pair1 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair2 = new PairOfFloatInt(3.14f, 2);
        PairOfFloatInt pair3 = new PairOfFloatInt(3.14f, 1);
        PairOfFloatInt pair4 = new PairOfFloatInt(0.3f, 9);
        PairOfFloatInt pair5 = new PairOfFloatInt(9.9f, 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((WritableComparatorTestHarness.compare(comparator, pair1, pair3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfFloatIntTest.class);
    }
}

