/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfFloatString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfFloatStringTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfFloatString pair = new PairOfFloatString(1.0f, "hi");
        Assert.assertEquals((Object)"hi", (Object)pair.getRightElement());
        Assert.assertTrue((pair.getLeftElement() == 1.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfFloatString origPair = new PairOfFloatString(2.0f, "hi");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfFloatString pair = new PairOfFloatString();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getRightElement());
        Assert.assertTrue((pair.getLeftElement() == 2.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfFloatString pair1 = new PairOfFloatString(1.0f, "hi");
        PairOfFloatString pair2 = new PairOfFloatString(1.0f, "hi");
        PairOfFloatString pair3 = new PairOfFloatString(0.0f, "hi");
        PairOfFloatString pair4 = new PairOfFloatString(0.0f, "a");
        PairOfFloatString pair5 = new PairOfFloatString(2.0f, "hi");
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfFloatString.Comparator comparator = new PairOfFloatString.Comparator();
        PairOfFloatString pair1 = new PairOfFloatString(1.0f, "hi");
        PairOfFloatString pair2 = new PairOfFloatString(1.0f, "hi");
        PairOfFloatString pair3 = new PairOfFloatString(0.0f, "hi");
        PairOfFloatString pair4 = new PairOfFloatString(0.0f, "a");
        PairOfFloatString pair5 = new PairOfFloatString(2.0f, "hi");
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfFloatStringTest.class);
    }
}

