/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class PairOfFloats
implements WritableComparable<PairOfFloats> {
    private float leftElement;
    private float rightElement;

    public PairOfFloats() {
    }

    public PairOfFloats(float left, float right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readFloat();
        this.rightElement = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.leftElement);
        out.writeFloat(this.rightElement);
    }

    public float getLeftElement() {
        return this.leftElement;
    }

    public float getRightElement() {
        return this.rightElement;
    }

    public float getKey() {
        return this.leftElement;
    }

    public float getValue() {
        return this.rightElement;
    }

    public void set(float left, float right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfFloats pair = (PairOfFloats)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfFloats pair) {
        float pl = pair.getLeftElement();
        float pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)this.leftElement & (int)this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfFloats clone() {
        return new PairOfFloats(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfFloats.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfFloats.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float thatLeftValue;
            float thisLeftValue = Comparator.readFloat((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readFloat((byte[])b2, (int)s2))) {
                float thatRightValue;
                float thisRightValue = Comparator.readFloat((byte[])b1, (int)(s1 + 4));
                return thisRightValue < (thatRightValue = Comparator.readFloat((byte[])b2, (int)(s2 + 4))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

