/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfIntFloat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfIntFloatTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfIntFloat pair = new PairOfIntFloat(1, 2.0f);
        Assert.assertEquals((double)1.0, (double)pair.getLeftElement(), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)pair.getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfIntFloat origPair = new PairOfIntFloat(1, 2.0f);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfIntFloat pair = new PairOfIntFloat();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((double)1.0, (double)pair.getLeftElement(), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)pair.getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfIntFloat pair1 = new PairOfIntFloat(1, 2.0f);
        PairOfIntFloat pair2 = new PairOfIntFloat(1, 2.0f);
        PairOfIntFloat pair3 = new PairOfIntFloat(1, 1.0f);
        PairOfIntFloat pair4 = new PairOfIntFloat(0, 9.0f);
        PairOfIntFloat pair5 = new PairOfIntFloat(9, 0.0f);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfIntFloat.Comparator comparator = new PairOfIntFloat.Comparator();
        PairOfIntFloat pair1 = new PairOfIntFloat(1, 2.0f);
        PairOfIntFloat pair2 = new PairOfIntFloat(1, 2.0f);
        PairOfIntFloat pair3 = new PairOfIntFloat(1, 1.0f);
        PairOfIntFloat pair4 = new PairOfIntFloat(0, 9.0f);
        PairOfIntFloat pair5 = new PairOfIntFloat(9, 0.0f);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfIntFloatTest.class);
    }
}

