/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class PairOfIntLong
implements WritableComparable<PairOfIntLong> {
    private int leftElement;
    private long rightElement;

    public PairOfIntLong() {
    }

    public PairOfIntLong(int left, long right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readInt();
        this.rightElement = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.leftElement);
        out.writeLong(this.rightElement);
    }

    public int getLeftElement() {
        return this.leftElement;
    }

    public long getRightElement() {
        return this.rightElement;
    }

    public int getKey() {
        return this.leftElement;
    }

    public long getValue() {
        return this.rightElement;
    }

    public void set(int left, long right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfIntLong pair = (PairOfIntLong)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfIntLong pair) {
        int pl = pair.getLeftElement();
        long pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)((long)this.leftElement + this.rightElement);
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfIntLong clone() {
        return new PairOfIntLong(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfIntLong.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfIntLong.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatLeftValue;
            int thisLeftValue = Comparator.readInt((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readInt((byte[])b2, (int)s2))) {
                long thatRightValue;
                long thisRightValue = Comparator.readLong((byte[])b1, (int)(s1 + 4));
                return thisRightValue < (thatRightValue = Comparator.readLong((byte[])b2, (int)(s2 + 4))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

