/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfIntLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfIntLongTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfIntLong pair = new PairOfIntLong(1, 2L);
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfIntLong origPair = new PairOfIntLong(1, 2L);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfIntLong pair = new PairOfIntLong();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfIntLong pair1 = new PairOfIntLong(1, 2L);
        PairOfIntLong pair2 = new PairOfIntLong(1, 2L);
        PairOfIntLong pair3 = new PairOfIntLong(1, 1L);
        PairOfIntLong pair4 = new PairOfIntLong(0, 9L);
        PairOfIntLong pair5 = new PairOfIntLong(9, 0L);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfIntLong.Comparator comparator = new PairOfIntLong.Comparator();
        PairOfIntLong pair1 = new PairOfIntLong(1, 2L);
        PairOfIntLong pair2 = new PairOfIntLong(1, 2L);
        PairOfIntLong pair3 = new PairOfIntLong(1, 1L);
        PairOfIntLong pair4 = new PairOfIntLong(0, 9L);
        PairOfIntLong pair5 = new PairOfIntLong(9, 0L);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfIntLongTest.class);
    }
}

