/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfInts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfIntsTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfInts pair = new PairOfInts(1, 2);
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfInts origPair = new PairOfInts(1, 2);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfInts pair = new PairOfInts();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfInts pair1 = new PairOfInts(1, 2);
        PairOfInts pair2 = new PairOfInts(1, 2);
        PairOfInts pair3 = new PairOfInts(1, 1);
        PairOfInts pair4 = new PairOfInts(0, 9);
        PairOfInts pair5 = new PairOfInts(9, 0);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfInts.Comparator comparator = new PairOfInts.Comparator();
        PairOfInts pair1 = new PairOfInts(1, 2);
        PairOfInts pair2 = new PairOfInts(1, 2);
        PairOfInts pair3 = new PairOfInts(1, 1);
        PairOfInts pair4 = new PairOfInts(0, 9);
        PairOfInts pair5 = new PairOfInts(9, 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfIntsTest.class);
    }
}

