/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class PairOfLongFloat
implements WritableComparable<PairOfLongFloat> {
    private long leftElement;
    private float rightElement;

    public PairOfLongFloat() {
    }

    public PairOfLongFloat(long left, float right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readLong();
        this.rightElement = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.leftElement);
        out.writeFloat(this.rightElement);
    }

    public long getLeftElement() {
        return this.leftElement;
    }

    public float getRightElement() {
        return this.rightElement;
    }

    public long getKey() {
        return this.leftElement;
    }

    public float getValue() {
        return this.rightElement;
    }

    public void set(long left, float right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfLongFloat pair = (PairOfLongFloat)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfLongFloat pair) {
        long pl = pair.getLeftElement();
        float pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)this.leftElement & (int)this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfLongFloat clone() {
        return new PairOfLongFloat(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfLongFloat.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfLongFloat.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatLeftValue;
            long thisLeftValue = Comparator.readLong((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readLong((byte[])b2, (int)s2))) {
                float thatRightValue;
                float thisRightValue = Comparator.readFloat((byte[])b1, (int)(s1 + 8));
                return thisRightValue < (thatRightValue = Comparator.readFloat((byte[])b2, (int)(s2 + 8))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

