/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.pair;

import edu.umd.cloud9.debug.WritableComparatorTestHarness;
import edu.umd.cloud9.io.pair.PairOfLongInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class PairOfLongIntTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfLongInt pair = new PairOfLongInt(1L, 2);
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfLongInt origPair = new PairOfLongInt(1L, 2);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write(dataOut);
        PairOfLongInt pair = new PairOfLongInt();
        pair.readFields(new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfLongInt pair1 = new PairOfLongInt(1L, 2);
        PairOfLongInt pair2 = new PairOfLongInt(1L, 2);
        PairOfLongInt pair3 = new PairOfLongInt(1L, 1);
        PairOfLongInt pair4 = new PairOfLongInt(0L, 9);
        PairOfLongInt pair5 = new PairOfLongInt(9L, 0);
        Assert.assertTrue((boolean)pair1.equals(pair2));
        Assert.assertFalse((boolean)pair1.equals(pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfLongInt.Comparator comparator = new PairOfLongInt.Comparator();
        PairOfLongInt pair1 = new PairOfLongInt(1L, 2);
        PairOfLongInt pair2 = new PairOfLongInt(1L, 2);
        PairOfLongInt pair3 = new PairOfLongInt(1L, 1);
        PairOfLongInt pair4 = new PairOfLongInt(0L, 9);
        PairOfLongInt pair5 = new PairOfLongInt(9L, 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair1, pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair3, pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare(comparator, pair4, pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfLongIntTest.class);
    }
}

